<?php

namespace SEOAIC\helpers;

class HTMLBuilers
{
    public static function options($styles = [], $default = '')
    {
        $html = '';

        foreach ($styles as $key => $value) {
            $selected = $key == $default ? ' selected' : '';
            $html .= '<option value="' . esc_attr($key) . '"' . $selected . '>' . esc_html($value) . '</option>';
        }

        return $html;
    }

    public static function textPlaceholder($wordsCount = 10, $minWordWidth = 1, $maxWordWidth = 12)
    {
        $out = '<p class="seoaic-placeholder-glow">';
        for ($i=0; $i < $wordsCount; $i++) {
            $wordLength = rand($minWordWidth, $maxWordWidth);
            $out .= '<span class="seoaic-word-placeholder seoaic-col-' . $wordLength . '"></span> ';
        }
        $out .= '</p>';

        return $out;
    }
}
