<?php

namespace SEOAIC\helpers;

class FormHelpers
{
    /**
     * Checks for a provided field name in the $_REQUEST array and check if it has a checked value
     * @param string $fieldName Field name
     * @return bool
     */
    public static function isCheckboxChecked($fieldName): bool
    {
        if (empty($fieldName)) {
            return false;
        }

        $__REQUEST = wp_unslash($_REQUEST); // phpcs:ignore WordPress.Security.NonceVerification.Recommended,WordPress.Security.NonceVerification.Missing

        return !empty($__REQUEST[$fieldName])
            && (
                $__REQUEST[$fieldName] === 'yes'
                || $__REQUEST[$fieldName] === 'on'
            );
    }
}
