<?php

namespace SEOAIC\content_improvement_suggestions;

class TitleTooShort extends AbstractTitleSuggestion
{
    public function __construct()
    {
        parent::__construct();

        $this->id = 'title_too_short';
        $this->label = esc_html__('Title too short', 'seoaic');
        $this->description = esc_html__('Indicates whether the content of the &lt;title&gt; tag is shorter than 30 characters.');
    }

    public function issueShouldBeFixed($value): bool
    {
        return !!$value;
    }
}
