<?php

namespace SEOAIC\content_improvement_suggestions;

class TitleTooLong extends AbstractTitleSuggestion
{
    public function __construct()
    {
        parent::__construct();

        $this->id = 'title_too_long';
        $this->label = esc_html__('Title too long', 'seoaic');
        $this->description = esc_html__('Indicates whether the content of the &lt;title&gt; tag exceeds 65 characters.');
    }

    public function issueShouldBeFixed($value): bool
    {
        return !!$value;
    }
}
