<?php

namespace SEOAIC\content_improvement_suggestions;

class TitleToContentConsistency extends AbstractTitleSuggestion
{
    public function __construct()
    {
        parent::__construct();

        $this->id = 'title_to_content_consistency';
        $this->label = esc_html__('Title-to-content consistency', 'seoaic');
        $this->description = esc_html__('Consistency of the meta `title` tag with the page content.');
    }

    public function issueShouldBeFixed($value): bool
    {
        return !$value;
    }
}
