<?php

namespace SEOAIC\content_improvement_suggestions;

class IrrelevantTitle extends AbstractTitleSuggestion
{
    public function __construct()
    {
        parent::__construct();

        $this->id = 'irrelevant_title';
        $this->label = esc_html__('Irrelevant title', 'seoaic');
        $this->description = esc_html__('Indicates whether a page &lt;title&gt; tag is irrelevant to the content of the page. The relevance threshold is 0.3. Available for canonical pages only.');
    }

    public function issueShouldBeFixed($value): bool
    {
        return !!$value;
    }
}
