<?php

namespace SEOAIC\content_improvement_suggestions;

class IrrelevantDescription extends AbstractDescriptionSuggestion
{
    public function __construct()
    {
        parent::__construct();

        $this->id = 'irrelevant_description';
        $this->label = esc_html__('Irrelevant description', 'seoaic');
        $this->description = esc_html__('Indicates whether a page `description` tag is irrelevant to the content of a page. The relevance threshold is 0.2. Available for canonical pages only.');
    }

    public function issueShouldBeFixed($value): bool
    {
        return !!$value;
    }
}
