<?php

namespace SEOAIC\content_improvement_suggestions;

class DuplicateTitle extends AbstractTitleSuggestion
{
    public function __construct()
    {
        parent::__construct();

        $this->id = 'duplicate_title';
        $this->label = esc_html__('Duplicate title', 'seoaic');
        $this->description = esc_html__('Indicates whether a page has duplicate &lt;title&gt; tags.');
    }

    public function issueShouldBeFixed($value): bool
    {
        return !!$value;
    }
}
