<?php

namespace SEOAIC\content_improvement_suggestions;

use SEOAIC\content_improvement_suggestions\AbstractContentImprovementSuggestion;
use WP_Post;

class DuplicateContent extends AbstractContentImprovementSuggestion
{
    public function __construct()
    {
        parent::__construct();

        $this->id = 'duplicate_content';
        $this->label = esc_html__('Duplicate content', 'seoaic');
        $this->description = esc_html__('Indicates whether a page has duplicate content.');
        $this->canGenerateSuggestion = false;
    }

    public function currentValue(WP_Post $post)
    {
        return '<a href="' . esc_url(get_permalink($post)) . '" target="_blank">Check the post <span class="dashicons dashicons-external"></span></a>';
    }

    public function issueShouldBeFixed($value): bool
    {
        return !!$value;
    }

    protected function applyNewValue(WP_Post $post, $newValue): bool
    {
        if (empty($newValue)) {
            return false;
        }

        // $result = $this->postRepository->updateField($post->ID, 'post_title', esc_html($newValue));
        $result = false;

        if (is_wp_error($result)) {
            return false;
        }

        return true;
    }
}
