<?php

namespace SEOAIC\content_improvement_suggestions;

use SEOAIC\content_improvement_suggestions\AbstractContentImprovementSuggestion;
use WP_Post;

class BrokenLinks extends AbstractContentImprovementSuggestion
{
    public function __construct()
    {
        parent::__construct();

        $this->id = 'broken_links';
        $this->label = esc_html__('Broken links', 'seoaic');
        $this->description = esc_html__('Indicates whether a page contains broken links.');
        $this->canGenerateSuggestion = false;
    }

    public function currentValue(WP_Post $post)
    {
        return '<a href="' . esc_url(get_permalink($post)) . '" target="_blank">Check the post <span class="dashicons dashicons-external"></span></a>';
    }

    public function issueShouldBeFixed($value): bool
    {
        return !!$value;
    }

    protected function applyNewValue(WP_Post $post, $newValue): bool
    {
        return true;
    }
}
