<?php

namespace SEOAIC\content_improvement_suggestions;

use SEOAIC\content_improvement_suggestions\AbstractContentImprovementSuggestion;
use WP_Post;

abstract class AbstractTitleSuggestion extends AbstractContentImprovementSuggestion
{
    public function __construct()
    {
        parent::__construct();

        $this->placeholderWordsCount = 5;
        $this->placeholderMinWordWidth = 1;
        $this->placeholderMaxWordWidth = 3;
    }

    public function currentValue(WP_Post $post)
    {
        return $post->post_title;
    }

    protected function applyNewValue(WP_Post $post, $newValue): bool
    {
        if (empty($newValue)) {
            return false;
        }

        $result = $this->postRepository->updateField($post->ID, 'post_title', esc_html($newValue));

        if (is_wp_error($result)) {
            return false;
        }

        return true;
    }
}
