<?php

namespace SEOAIC\content_improvement_suggestions;

use SEOAIC\content_improvement_suggestions\AbstractContentImprovementSuggestion;
use SEOAIC\helpers\SEOPluginsHelper;
use WP_Post;

abstract class AbstractDescriptionSuggestion extends AbstractContentImprovementSuggestion
{
    public function __construct()
    {
        parent::__construct();
    }

    public function currentValue(WP_Post $post)
    {
        $seoPlugin = SEOPluginsHelper::getAvailableSEOPlugin();
        $metaDescription = $seoPlugin ? $seoPlugin->getDescription($post->ID) : '';

        return $metaDescription;
    }

    protected function applyNewValue(WP_Post $post, $newValue): bool
    {
        if (empty($newValue)) {
            return false;
        }

        $seoPlugin = SEOPluginsHelper::getAvailableSEOPlugin();
        if ($seoPlugin) {
            $seoPlugin->setDescription($post->ID, $newValue);

            return true;
        }

        return false;
    }
}
