<?php

namespace SEOAIC;

use SEOAIC\shortcodes\FAQ;
use SEOAIC\shortcodes\InteractiveArticleBlock;
use SEOAIC\shortcodes\MultistepForm;
use SEOAIC\shortcodes\PostAuthor;
use SEOAIC\shortcodes\PostContent;
use SEOAIC\shortcodes\PostPublished;
use SEOAIC\shortcodes\PostsArchiveLink;
use SEOAIC\shortcodes\PostThumbnail;
use SEOAIC\shortcodes\PostTitle;
use SEOAIC\shortcodes\PostUpdated;

class SeoaicShortcodes
{
    public const MULTISTEP_FORM_SHORTCODE = 'seoaic_multistep_form';
    public const INTERACTIVE_SHORTCODE = 'seoaic_interactive_block';
    public const FAQ_SHORTCODE = 'seoaic_faq';
    public const POST_THUMBNAIL_SHORTCODE = 'seoai_post_thumbnail';
    public const POST_CONTENT_SHORTCODE = 'seoai_post_content';
    public const POST_TITLE_SHORTCODE = 'seoai_post_title';
    public const POST_AUTHOR_SHORTCODE = 'seoai_post_author';
    public const POST_PUBLISHED_SHORTCODE = 'seoai_post_published';
    public const POST_UPDATED_SHORTCODE = 'seoai_post_updated';
    public const POSTS_ARCHIVE_LINK_SHORTCODE = 'seoai_posts_archive_link';

    public function __construct()
    {
        $this->initShortcodes();
    }

    private function initShortcodes()
    {
        add_shortcode(self::MULTISTEP_FORM_SHORTCODE, [$this, 'shortcodeMultistepForm']);
        add_shortcode(self::INTERACTIVE_SHORTCODE, [$this, 'shortcodeInteractiveBlock']);
        add_shortcode(self::FAQ_SHORTCODE, [$this, 'shortcodeFAQ']);
        add_shortcode(self::POST_THUMBNAIL_SHORTCODE, [$this, 'shortcodePostThumbnail']);
        add_shortcode(self::POST_CONTENT_SHORTCODE, [$this, 'shortcodePostContent']);
        add_shortcode(self::POST_CONTENT_SHORTCODE, [$this, 'shortcodePostContent']);
        add_shortcode(self::POST_TITLE_SHORTCODE, [$this, 'shortcodePostTitle']);
        add_shortcode(self::POST_AUTHOR_SHORTCODE, [$this, 'shortcodePostAuthor']);
        add_shortcode(self::POST_PUBLISHED_SHORTCODE, [$this, 'shortcodePostPublished']);
        add_shortcode(self::POST_UPDATED_SHORTCODE, [$this, 'shortcodePostUpdated']);
        add_shortcode(self::POSTS_ARCHIVE_LINK_SHORTCODE, [$this, 'shortcodePostsArchiveLink']);

        add_filter('no_texturize_shortcodes', [$this, 'excludeTexturize']);
    }

    function excludeTexturize($shortcodes)
    {
        $shortcodes[] = self::MULTISTEP_FORM_SHORTCODE;
        $shortcodes[] = self::INTERACTIVE_SHORTCODE;
        $shortcodes[] = self::FAQ_SHORTCODE;

        return $shortcodes;
    }

    public function shortcodeMultistepForm($atts, $content)
    {
        $multistepForm = new MultistepForm($atts, $content);

        return $multistepForm->html();
    }

    public function shortcodeInteractiveBlock($atts, $content)
    {
        $interactiveBlock = new InteractiveArticleBlock($atts, $content);

        return $interactiveBlock->html();
    }

    public function shortcodeFAQ($atts, $content)
    {
        $faqBlock = new FAQ($atts, $content);

        return $faqBlock->html();
    }

    public function shortcodePostContent($atts, $content)
    {
        $shortcode = new PostContent($atts, $content);

        return $shortcode->html();
    }

    public function shortcodePostThumbnail($atts, $content)
    {
        $shortcode = new PostThumbnail($atts, $content);

        return $shortcode->html();
    }

    public function shortcodePostTitle($atts, $content)
    {
        $shortcode = new PostTitle($atts);

        return $shortcode->html();
    }

    public function shortcodePostAuthor($atts)
    {
        $shortcode = new PostAuthor($atts);

        return $shortcode->html();
    }

    public function shortcodePostPublished($atts)
    {
        $shortcode = new PostPublished($atts);

        return $shortcode->html();
    }

    public function shortcodePostUpdated($atts)
    {
        $shortcode = new PostUpdated($atts);

        return $shortcode->html();
    }

    public function shortcodePostsArchiveLink($atts)
    {
        $shortcode = new PostsArchiveLink($atts);

        return $shortcode->html();
    }
}
