<?php

namespace SEOAIC;

use DateTime;
use DateTimeZone;
use Exception;
use SEOAIC\helpers\WPTransients;
use SeoaicAjaxValidation;

class SEOAIC_COMPETITORS
{
    private $seoaic;
    private const COMPETITORS_AS_CATEGORIES_KEY = 'seoaic_competitors';
    private const KEYWORDS_CACHE_KEY = 'seoaic_keywords';
    private const NEXT_UPDATE_DAYS = 30 * DAY_IN_SECONDS;
    private const TERMS_POST_TYPE = 'seoaic-search-terms';
    private const SEARCH_TERMS_CACHE_KEY = 'seoaic-search-terms';
    public const LAST_UPDATE_FIELD = 'competitors_last_update';

    public function __construct($_seoaic)
    {
        $this->seoaic = $_seoaic;
        add_action('wp_ajax_seoaic_Add_New_Competitor', [$this, 'Add_New_Competitor_Ajax'], 99);
        add_action('wp_ajax_seoaic_location_tabs_sorting', [$this, 'location_tabs_sorting'], 99);
        add_action('wp_ajax_seoaic_insert_my_competitor_term', [$this, 'insert_my_competitor_term'], 99);
        add_action('wp_ajax_seoaic_add_competitor_location', [$this, 'add_competitor_location'], 99);
        add_action('wp_ajax_seoaic_remove_competitor_location', [$this, 'remove_competitor_location'], 99);
        add_action('wp_ajax_seoaic_remove_competitor', [$this, 'Remove_Competitor'], 99);
        add_action('wp_ajax_seoaic_Remove_Term', [$this, 'Remove_Term'], 99);
        add_action('wp_ajax_seoaic_Competitors_Compare_Section_HTML', [$this, 'Competitors_Compare_Section_HTML_Ajax']);
        add_action('wp_ajax_seoaic_Competitors_Search_Terms_HTML', [$this, 'Competitors_Search_Terms_HTML_Ajax']);
        add_action('wp_ajax_seoaic_get_keywords_options', [$this, 'get_keywords_options']);
        //add_action('wp_ajax_seoaic_competitors_keywords_ranks_timeline', [$this, 'keywords_ranks_timeline']);
        add_action('wp_ajax_seoaic_Check_Terms_Update_Progress', [$this, 'Check_Terms_Update_Progress']);
        add_action('wp_ajax_seoaic_Progress_Values', [$this, 'set_values_my_rank_in_progress']);
        add_action('wp_ajax_seoaic_Prepare_Article_Based_Search_Term', [$this, 'Prepare_Article_Based_Search_Term']);
        add_action('wp_ajax_seoaic_update_competitor_data', [$this, 'update_competitors_data_ajax']);
        add_action('wp_ajax_seoaic_validate_positions_real_terms_count', [$this, 'validate_positions_all_competitors_ajax']);
        add_action('wp_ajax_seoaic_competitors_refresh_manual', [$this, 'updateCompetitorsDataManualAjax']);
        add_action('wp_ajax_seoaic_compare_competitors', [$this, 'compare_competitors']);
        add_action('wp_ajax_seoaic_get_top_google_analysis', [$this, 'get_top_google_analysis']);
        add_action('wp_ajax_seoaic_migrate_competitors_from_options', [$this, 'migrate_competitors_from_options']);
        add_action('wp_ajax_seoaic_compare_my_article', [$this, 'COMPARE_my_article']);
        add_action('wp_ajax_seoaic_compare_my_competitors', [$this, 'COMPARE_my_competitors']);
        add_action('wp_ajax_seoaic_compare_analysis', [$this, 'COMPARE_analysis']);
        add_action('wp_ajax_seoaic_compare_other_positions', [$this, 'COMPARE_other_positions']);

        add_action('init', [$this, 'registerCompetitorsAsTaxonomy']);
        add_action('init', [$this, 'defaultOptions']);

        // View competitors in keywords
        add_action('wp_ajax_seoaic_get_search_term_competitors', [$this, 'get_keyword_competitors_ajax']);
        add_action('wp_ajax_seoaicAddedCompetitors', [$this, 'added_keyword_competitors']);
        add_action('wp_ajax_seoaic_my_article_popup_top_table_analysis', [$this, 'my_article_popup_top_table_analysis_ajax']);
        add_action('wp_ajax_seoaic_competitor_article_popup_table_analysis', [$this, 'competitor_article_popup_table_analysis_ajax']);
    }

    public function get_keywords_options()
    {
        check_ajax_referer(SeoaicAjaxValidation::ACTION_STRING);

        global $SEOAIC;

        $keywords = $SEOAIC->keywords->getKeywords();

        if (!$keywords) {
            return;
        }

        $html = '';

        foreach ($keywords as $keyword) {
            $html .= '<option value="' . esc_attr($keyword['id']) . '">' . esc_html($keyword['name']) . '</option>';
        }

        wp_send_json(
            [
                'status' => 'success',
                'html' => $html
            ]
        );
    }

    public function defaultOptions()
    {
        global $SEOAIC_OPTIONS;
        if (!isset($SEOAIC_OPTIONS['seoaic_competitors_update_interval'])) {
            $SEOAIC_OPTIONS['seoaic_competitors_update_interval'] = self::NEXT_UPDATE_DAYS;
            update_option('seoaic_options', $SEOAIC_OPTIONS);
        }
    }

    public function nextUpdate()
    {
        global $SEOAIC_OPTIONS;
        if (intval($SEOAIC_OPTIONS['seoaic_competitors_update_interval']) != self::NEXT_UPDATE_DAYS) {
            $SEOAIC_OPTIONS['seoaic_competitors_update_interval'] = self::NEXT_UPDATE_DAYS;
            update_option('seoaic_options', $SEOAIC_OPTIONS);
            return false;
        }

        return true;
    }

    public function registerCompetitorsAsTaxonomy()
    {
        register_taxonomy(self::COMPETITORS_AS_CATEGORIES_KEY, self::TERMS_POST_TYPE, [
            'public' => false,
            'rewrite' => false,
        ]);
    }

    public function seoaic_location()
    {
        global $SEOAIC_OPTIONS;
        return !empty($SEOAIC_OPTIONS['seoaic_location']) ? $SEOAIC_OPTIONS['seoaic_location'] : 'United States';
    }

    public function seoaic_language()
    {
        global $SEOAIC_OPTIONS;
        return !empty($SEOAIC_OPTIONS['seoaic_language']) ? $SEOAIC_OPTIONS['seoaic_language'] : 'English';
    }

    public function seoaic_company_website_url()
    {
        global $SEOAIC_OPTIONS;
        $company_website = !empty($SEOAIC_OPTIONS['seoaic_company_website']) ? $SEOAIC_OPTIONS['seoaic_company_website'] : get_bloginfo('url');
        return preg_replace('/^www\./', '', wp_parse_url($company_website)['host']);
    }

    /**
     * @return void
     */
    public function add_competitor_location()
    {
        $this->insert_my_competitor_term();
        wp_die();
    }

    public function get_competitors_locations()
    {
        global $SEOAIC_OPTIONS;

        $regions = $SEOAIC_OPTIONS['competitors_locations_countries'];

        if (is_array($regions)) {
            return array_unique($regions);
        }

        return false;
    }

    public function remove_competitor_location()
    {
        check_ajax_referer(SeoaicAjaxValidation::ACTION_STRING);

        global $SEOAIC_OPTIONS;

        if (empty($_REQUEST['item_id'])) {
            return;
        }

        $location = $_REQUEST['item_id'];

        $competitors = $this->get_competitors($location);

        $SEOAIC_OPTIONS['competitors_locations_countries'] = array_diff($SEOAIC_OPTIONS['competitors_locations_countries'], [$location]);
        update_option('seoaic_options', $SEOAIC_OPTIONS);

        foreach ($competitors as $competitor) {
            wp_delete_term($competitor->term_id, self::COMPETITORS_AS_CATEGORIES_KEY);
        }

    }

    public function location_tabs_sorting()
    {
        check_ajax_referer(SeoaicAjaxValidation::ACTION_STRING);

        global $SEOAIC_OPTIONS;

        $SEOAIC_OPTIONS['competitors_locations_countries'] = $_REQUEST['locations'];
        update_option('seoaic_options', $SEOAIC_OPTIONS);

        wp_die();
    }

    public function location_progress($location)
    {
        $ID = $this->get_my_site_id($location);

        if (!$ID) {
            return 0;
        }

        $historical_rank = get_term_meta($ID, 'historical_rank', true);
        if (isset($historical_rank[0]['metrics'])) {
            $metrics = $historical_rank[0]['metrics'];
        }
        $pos_1 = empty($metrics['pos_1_3']) ? '-' : $metrics['pos_1_3'];
        $pos_2_3 = empty($metrics['pos_4_10']) ? '-' : $metrics['pos_4_10'];
        $pos_4_10 = empty($metrics['pos_11_30']) ? '-' : $metrics['pos_11_30'];
        $pos_11_20 = empty($metrics['pos_31_50']) ? '-' : $metrics['pos_31_50'];
        $pos_21_30 = empty($metrics['pos_51_100']) ? '-' : $metrics['pos_51_100'];

        return intval($pos_1) + intval($pos_2_3) + intval($pos_4_10) + intval($pos_11_20) + intval($pos_21_30);
    }

    public function count_all_locations_positions()
    {
        $regions = $this->get_competitors_locations();

        $count = 0;
        foreach ($regions as $region) {

            $count = $count + $this->location_progress($region);

        }

        return $count;
    }

    public function location_tabs_progress($location)
    {
        if (!$this->count_all_locations_positions()) {
            return 0;
        }
        return $this->location_progress($location) * 100 / $this->count_all_locations_positions();
    }

    public function location_tabs_progress_color($location)
    {
        $percent = $this->location_tabs_progress($location);

        $color = '#00a800';
        if ($percent < 5) {
            $color = 'red';
        }

        return $color;
    }

    public function locations_tabs_HTML()
    {
        global $pagenow, $SEOAIC_OPTIONS;

        $page = isset($_GET['page']) ? '&page=' . $_GET['page'] : '';
        $get_regions = $this->get_competitors_field_val('location');

        if (empty($SEOAIC_OPTIONS['competitors_locations_countries']) || count($get_regions) > count($SEOAIC_OPTIONS['competitors_locations_countries'])) {
            $SEOAIC_OPTIONS['competitors_locations_countries'] = $get_regions;
            update_option('seoaic_options', $SEOAIC_OPTIONS);
        }

        $regions = array_unique($SEOAIC_OPTIONS['competitors_locations_countries']);

        if (count($SEOAIC_OPTIONS['competitors_locations_countries']) !== count($regions)) {
            $SEOAIC_OPTIONS['competitors_locations_countries'] = $get_regions;
            update_option('seoaic_options', $SEOAIC_OPTIONS);
        }

        $settings_location = $this->seoaic_location();

        $region_html = '<ul>';
        foreach ($regions as $region) {

            $progress = '<div class="progress"><span style="background-color: ' . $this->location_tabs_progress_color($region) . '; min-width: 4%; width: ' . $this->location_tabs_progress($region) . '%"></span></div>';

            $selected = '';
            if (isset($_GET['location']) && $_GET['location'] === $region) {
                $selected = ' selected';
            } else if ($settings_location === $region && !isset($_GET['location'])) {
                $selected = ' selected';
            }
            $path = '&location=' . $region;
            $remove_btn = $settings_location !== $region ? '<button data-post-id="' . $region . '" data-content="' . esc_html__('Do you want to remove this location with the competitors?', 'seoaic') . '" data-action="seoaic_remove_competitor_location" class="confirm-modal-button closeTab modal-button" data-form-callback="window_reload" data-modal="#seoaic-confirm-modal">✕</button>' : '<button class="closeTab"></button>';
            $region_html .= '<li data-my-site="' . $this->is_our_competitor_exists($region) . '" data-progress="' . $this->location_tabs_progress($region) . '" class="tab' . $selected . '"><a href="' . admin_url($pagenow . '?' . $page . $path) . '">' . $region . '</a>' . $remove_btn . $progress . '</li>';
        }
        $region_html .= '<li class="add"><button data-modal="#add-competitor-location" class="add-new-location modal-button"></button></li>';
        $region_html .= '</ul>';

        return $region_html;
    }

    public function keywordsRankedLocationsTabsHTML()
    {
        global $pagenow, $SEOAIC_OPTIONS;

        $page = isset($_GET['page']) ? '&page=' . $_GET['page'] : '';
        $regions = !empty($SEOAIC_OPTIONS['competitors_locations_countries']) ? array_unique($SEOAIC_OPTIONS['competitors_locations_countries']) : [];
        $settings_location = $this->seoaic_location();

        $region_html = '';

        if (!empty($regions)) {
            $region_html = '<ul>';

            foreach ($regions as $region) {
                $selected = '';
                if (isset($_GET['location']) && $_GET['location'] === $region) {
                    $selected = ' selected';
                } else if ($settings_location === $region && !isset($_GET['location'])) {
                    $selected = ' selected';
                }
                $path = '&location=' . $region;
                $region_html .= '<li data-my-site="' . $this->is_our_competitor_exists($region) . '" data-progress="' . $this->location_tabs_progress($region) . '" class="tab' . $selected . '"><a href="' . admin_url($pagenow . '?' . $page . $path) . '">' . $region . '</a>' . '</li>';
            }
            $region_html .= '</ul>';
        }

        return $region_html;
    }

    private function removeKeywords(&$filteredData, $search_terms): void
    {
        foreach ($filteredData as &$position) {
            foreach ($position['metrics'] as &$metric) {
                if (is_array($metric)) {
                    $metric = array_filter($metric, function ($keyword) use ($search_terms) {
                        return !isset($search_terms[$keyword]);
                    });
                    $metric = array_values($metric); // Reset array keys
                }
            }
        }
    }

    private function update_positions_count(&$filteredData): void
    {
        foreach ($filteredData as &$position) {
            if (isset($position['metrics']) && is_array($position['metrics'])) {
                foreach ($position['metrics'] as $key => &$metric) {
                    if (is_array($metric)) {
                        $position['metrics'][$key] = count($metric);
                    }
                }
            }
        }
    }

    public function keywords_ranks_timeline($search_terms, $rank_history, $language, $location, $url)
    {

        global $SEOAIC, $SEOAIC_OPTIONS;

        $data = [
            'email' => $SEOAIC_OPTIONS['seoaic_api_email'],
            'token' => $SEOAIC_OPTIONS['seoaic_api_token'],
            'language' => $language,
            'location' => $location,
            'target' => $url,
            'date' => date('Y-m-d\TH:i:s.v\Z', time()),
        ];

        $keywords_ranks_timeline = $SEOAIC->curl->init('/api/ai/keywords-ranks-timeline', $data, true, true, true);

//        $filteredData = array_filter($keywords_ranks_timeline['data'], function ($item) {
//            return filter_out_empty_metrics($item['metrics']);
//        });

        $filteredData = array_filter($keywords_ranks_timeline['data'], function ($item) {
            return array_reduce($item['metrics'], function ($carry, $metric) {
                return $carry || !empty($metric);
            }, false);
        });


        $search_terms = array_flip(array_column(array_values($search_terms['data']), 'keyword'));

        $this->removeKeywords($filteredData, $search_terms);
        $this->update_positions_count($filteredData);

        foreach ($filteredData as $local_metrics) {
            $month_local = $local_metrics['month'];
            $year_local = $local_metrics['year'];
            $metrics_local = $local_metrics['metrics'];

            foreach ($rank_history['data'] as $data_key => $external_metrics) {
                $month_ex = $external_metrics['month'];
                $year_ex = $external_metrics['year'];

                if ($month_local == $month_ex && $year_local == $year_ex) {
                    foreach ($metrics_local as $key => $metric_local) {
                        $rank_history['data'][$data_key]['metrics'][$key] += $metric_local;
                    }
                }
            }
        }

        return $rank_history;

    }

    public function request_data_competitors($language, $location, $url)
    {
        global $SEOAIC_OPTIONS, $SEOAIC;
        $data = [
            'email' => $SEOAIC_OPTIONS['seoaic_api_email'],
            'token' => $SEOAIC_OPTIONS['seoaic_api_token'],
            'language' => $language,
            'location' => $location,
            'target' => $url,
            'add_terms' => 'word',
            'date' => date('m/d/Y h:i:s a', time()),
        ];

        $result = $SEOAIC->curl->init('api/ai/competitors-search-terms', $data, true, true, true);
        $rank_history = $SEOAIC->curl->init('api/ai/historical-rank', $data, true, true, true);
        $backlinks_result = $SEOAIC->curl->init('api/ai/backlinks-domain', $data, true, true, true);

        $backlinks = isset($backlinks_result['data'][0]['results']['result'][0]['backlinks']) ? intval($backlinks_result['data'][0]['results']['result'][0]['backlinks']) : 0;

        $rank_history =
            !empty($rank_history['data']) ?
                $this->keywords_ranks_timeline($result, $rank_history, $language, $location, $url)['data'] :
                [];

        $next_update = time() + self::NEXT_UPDATE_DAYS;

        return [
            'result' => $result,
            'rank_history' => $rank_history,
            'backlinks_result' => $backlinks,
            'next_update' => $next_update,
        ];

    }

    public function competitors_fields($ID, $next_update, $url, $slugLocation, $location, $search_terms, $backlinks, $rank_history, $reordered_rank_history = [])
    {

        global $SEOAIC, $SEOAIC_OPTIONS, $wpdb;

        $my_site = $this->seoaic_company_website_url();
        $my_location = $this->seoaic_location();
        $slug = $url . $slugLocation;
        $tax = self::COMPETITORS_AS_CATEGORIES_KEY;

        if (!$ID) {
            $wpdb->insert(
                $wpdb->terms,
                array(
                    'name' => $url . ' (' . $location . ')',
                    'slug' => $slug,
                    'term_group' => 0
                ),
                array(
                    '%s',
                    '%s',
                    '%d'
                )
            );

            $term_id = $wpdb->insert_id;

            $wpdb->insert(
                $wpdb->term_taxonomy,
                array(
                    'term_id' => $term_id,
                    'taxonomy' => $tax,
                    'description' => '',
                    'parent' => 0,
                    'count' => 0
                ),
                array(
                    '%d',
                    '%s',
                    '%s',
                    '%d',
                    '%d'
                )
            );

            $term_taxonomy_id = $wpdb->insert_id;

            $competitor = array(
                'term_id' => $term_id,
                'term_taxonomy_id' => $term_taxonomy_id
            );

        } else {

            $wpdb->update(
                $wpdb->terms,
                array(
                    'name' => $url . ' (' . $location . ')',
                    'slug' => $slug
                ),
                array('term_id' => $ID),
                array(
                    '%s',
                    '%s'
                ),
                array('%d')
            );

            $term_taxonomy_id = $wpdb->get_var($wpdb->prepare("SELECT term_taxonomy_id FROM $wpdb->term_taxonomy WHERE term_id = %d AND taxonomy = %s", $ID, $tax));

            $competitor = array(
                'term_id' => $ID,
                'term_taxonomy_id' => $term_taxonomy_id
            );
        }

        if (is_wp_error($competitor)) {
            SEOAICAjaxResponse::error('Error: ' . $slug . ' ' . $competitor->get_error_message())->wpSend();
        } else {
            $id = $competitor['term_id'];
            if ($url === $my_site && $location === $my_location) {
                $SEOAIC_OPTIONS['my_competitor_term_id'] = $id;
                update_option('seoaic_options', $SEOAIC_OPTIONS);
            }

            $competitor_values = array(
                'next_update' => $next_update,
                'url' => $url . $slugLocation,
                'url_live' => $url,
                'url_display' => $url . ' (' . $location . ')',
                'backlinks' => $backlinks,
                'location' => $location,
                'historical_rank' => !$reordered_rank_history ? $this->reorder_positions_stats($rank_history) : $reordered_rank_history,
                'search_terms' => $search_terms,
                'my_website' => false
            );

            foreach ($competitor_values as $key => $value) {
                update_term_meta($id, $key, $value);
            }

            if ($url === $my_site) {
                $this->validate_positions_all_competitors();
            }
        }
    }

    public function update_competitors_search_term_field($competitor_id, $search_term_index, $field, $new_value)
    {
        $earch_terms = $this->get_search_terms($competitor_id);
        $earch_terms[$search_term_index][$field] = $new_value;
        update_term_meta($competitor_id, 'search_terms', $earch_terms);
    }

    public function get_competitors($location = '')
    {
        $meta_location = $location ? [
            'key' => 'location',
            'value' => $location,
            'compare' => '='
        ] : [];


        $my_website_url = $this->seoaic_company_website_url();
        $get_competitors = get_terms(
            [
                'taxonomy' => self::COMPETITORS_AS_CATEGORIES_KEY,
                'hide_empty' => false,
                'meta_query' => [
                    'relation' => 'AND',
                    [
                        'key' => 'url_live',
                        'value' => $my_website_url,
                        'compare' => '!='
                    ],
                    $meta_location
                ]
            ]);

        $get_my = get_terms([
            'taxonomy' => self::COMPETITORS_AS_CATEGORIES_KEY,
            'hide_empty' => false,
            'meta_query' => [
                'relation' => 'AND',
                [
                    'key' => 'url_live',
                    'value' => $my_website_url,
                    'compare' => '='
                ],
                $meta_location
            ]
        ]);

        if (isset($get_my)) {
            foreach ($get_my as $my) {
                array_unshift($get_competitors, $my);
            }
        }

        return $get_competitors;
    }

    public function get_competitor_field_val($id, $field_name)
    {
        return get_term_meta($id, $field_name, true);
    }

    public function get_search_terms($competitor_id, $search_keyword = '')
    {
        $search_keyword = trim($search_keyword);

        $search_terms = $this->get_competitor_field_val($competitor_id, 'search_terms');
        if (!$search_terms) {
            $search_terms = [];
        }

        if ($search_keyword) {
            $search_terms = array_filter($search_terms, function ($item) use ($search_keyword) {
                return stripos($item['keyword'], $search_keyword) !== false;
            });
        }
        return $search_terms;
    }

    public function get_search_terms_field_val($competitor_id, $field_name)
    {
        $search_terms = $this->get_search_terms($competitor_id);
        $values = [];
        foreach ($search_terms as $term) {
            $integer_fields = array('position', 'page_rank', 'search_volume', 'etv', 'etc', 'backlinks');

            if (in_array($field_name, $integer_fields)) {
                $values[] = intval($term[$field_name]);
            } else {
                $values[] = $term[$field_name];
            }
        }

        return $values;
    }

    public function get_competitors_field_val($field_name, $location = '')
    {

        $competitors = $this->get_competitors($location);
        $values = [];
        foreach ($competitors as $competitor) {
            $values[] = get_term_meta($competitor->term_id, $field_name, true);
        }
        return $values;
    }

    public function Add_New_Competitor_Ajax()
    {
        check_ajax_referer(SeoaicAjaxValidation::ACTION_STRING);

        $this->Add_New_Competitor();
    }

    /**
     * Prepare Competitors URL
     * @throws Exception
     * $domains string
     */
    public function Add_New_Competitor($domains = '', $loco = '', $i = 0, $update = false, $response = false)
    {
        global $SEOAIC_OPTIONS, $SEOAIC;

        $my_site = $this->seoaic_company_website_url();

        if (!$this->get_competitors()) {
            $item_name = $my_site;
        }

        if (empty($_REQUEST['item_name']) and empty($item_name) and empty($domains)) {
            return;
        }

        if ($domains && $update) {
            $_REQUEST['item_name'] = $domains;
        }

        $language = $this->seoaic_language();
        $location = $this->get_the_location_param();

        if (!empty($_REQUEST['seoaic_location'])) {
            $location = $_REQUEST['seoaic_location'];
            $language = seoaic_get_preferred_language($location);
        }

        if (!empty($loco)) {
            $location = $loco;
            $language = seoaic_get_preferred_language($loco);
        }

        $slugLocation = '_' . $this->Slug($location);

        $competitors = !empty($_REQUEST['item_name']) ? explode(',', $_REQUEST['item_name']) : [];

        // remove all spaces
        $competitors = preg_replace('/\s+/', '', $competitors);

        $regex = "((https?|ftp)\:\/\/)?";
        $regex .= "([a-z0-9+!*(),;?&=\$_.-]+(\:[a-z0-9+!*(),;?&=\$_.-]+)?@)?";
        $regex .= "([a-z0-9-.]*)\.([a-z]{2,10})";
        $regex .= "(\:[0-9]{2,5})?";
        $regex .= "(\/([a-z0-9+\$_-]\.?)+)*\/?";
        $regex .= "(\?[a-z+&\$_.-][a-z0-9;:@&%=+\/\$_.-]*)?";
        $regex .= "(#[a-z_.-][a-z0-9+\$_.-]*)?";

        //$addedURLS = [];
        $addedURLS_locations = [];
        $get_competitors = $this->get_competitors($location);
        if (!empty($get_competitors)) {
            foreach ($get_competitors as $competitor) {
                $id = $competitor->term_id;
                $url = $this->get_competitor_field_val($id, 'url');
                $addedURLS_locations[] = !empty($url) ? $url : '';
            }
        }

        $validURL = [];
        $notValidURL = [];
        $existURL = [];
        $myOwnURL = [];

        $all_sites = $SEOAIC->competitors->get_competitors_field_val('url_live', $location);

        foreach (array_unique($competitors) as $competitor) {
            $url = self::Slugify_url($competitor);

            if ($update) {
                $validURL[] = $url;
            } else {
                if ($competitor === $my_site && in_array($my_site, $all_sites)) {
                    $myOwnURL[] = $url;

//                    wp_send_json([
//                        'all_sites' => $all_sites,
//                        'my_site' => $my_site,
//                    ]);

                } else {
                    if (in_array($url . $slugLocation, $addedURLS_locations)) {
                        $existURL[] = $url;
                    } else {
                        if (preg_match("/^$regex$/i", $url)) {
                            $validURL[] = $url;
                        } else {
                            $notValidURL[] = $url;
                        }
                    }
                }
            }
        }

        // Add our website url in to competitors with a first run
        $all_urls = $this->get_competitors_field_val('url_live');
        if (!in_array($my_site, $all_urls)) {
            array_unshift($validURL, $my_site);
        }

        $validURL = array_unique($validURL);

        foreach ($validURL as $url) {

            $data_request = $this->request_data_competitors($language, $location, $url);

            $result = $data_request['result'];
            $rank_history = $data_request['rank_history'];
            $backlinks_result = $data_request['backlinks_result'];
            $next_update = $data_request['next_update'];

            $search_terms = [];
            if (!empty($result['data']) && count($result['data']) > 1) {
                foreach ($result['data'] as $terms) {
                    $search_terms[random_int(100000000, 999999999)] = $terms;
                }
            }

            if ($update) {

                if ($url == $my_site) {
                    $SEOAIC_OPTIONS['on_page_seo_data']['historical_positions'] = $this->reorder_positions_stats($rank_history);
                }

                $this->competitors_fields($i, $next_update, $url, $slugLocation, $location, $search_terms, $backlinks_result, $rank_history);

                $validURL = $validURL ? 'Competitor «' . implode(',', $validURL) . '» has been updated! <br><br>' : '';

                wp_send_json([
                    'competitor_data_html' => $this->competitor_card_data_HTML($i)
                ]);
            }

            if ($url == $my_site) {
                $SEOAIC_OPTIONS['on_page_seo_data']['historical_positions'] = $this->reorder_positions_stats($rank_history);
            }

            $this->competitors_fields(0, $next_update, $url, $slugLocation, $location, $search_terms, $backlinks_result, $rank_history);

        }

        $valid = $validURL ? 'Competitors «' . implode(',', $validURL) . '» has been added! <br><br>' : '';
        $notValidURL = $notValidURL ? 'Not valid URL «' . implode(',', $notValidURL) . '» check and try again! <br><br>' : '';
        $existURL = $existURL ? 'Competitors «' . implode(',', $existURL) . '» already exists! <br><br>' : '';
        $myOwnURL = $myOwnURL ? 'You can\'t add your own website: «' . implode(',', $myOwnURL) . '» <br><br>' : '';

        if ($response && $validURL) {
            $id = $this->get_my_site_id($location);

            $positions = [
                '1-3',
                '4-10',
                '11-30',
                '31-50',
                '51-100',
            ];

            $heading = '<div class="row-line heading">
                    <div class="check"></div>
                    <div class="company-name"></div>
                    <div class="page"></div>';

            foreach ($positions as $position) {
                $heading .= '<div class="position">' . esc_html__('Position', 'seoaic') . esc_html(' ' . $position) . '</div>';
            }

            $heading .= '<div class="open-all-positions"></div>
                 <div class="delete"></div>
                </div>';

            wp_send_json([
                'competitor_data_html' => $this->competitor_card_HTML($id, $my_site),
                'competitor_heading_html' => $heading,
                'competitor_location_progress' => 'background-color: ' . $this->location_tabs_progress_color($location) . '; min-width: 4%; width: ' . $this->location_tabs_progress($location) . '%,'
            ]);
        }

        if (empty($_REQUEST['action'])) {
            return;
        }

        SEOAICAjaxResponse::alert($valid . $notValidURL . $existURL . $myOwnURL)->wpSend();
    }

    private function fix_www_domain_url()
    {
        $my_competitor = $this->our_own_website_url_for_competitors();

        if (strpos($my_competitor['my_website'], 'www.') === 0) {
            $this->change_our_own_url();
        }
    }

    /**
     * @throws Exception
     */
    public function change_our_own_url()
    {

        if (!$this->get_competitors()) {
            return;
        }

        $our_competitor_id = $this->our_own_website_index();

        $language = $this->seoaic_language();
        $location = $this->seoaic_location();
        $slugLocation = '_' . $this->Slug($location);

        $company_website = $this->seoaic_company_website_url();
        $my_competitor = $this->our_own_website_url_for_competitors();

        $my_website = $my_competitor['my_website'];
        $my_location = $my_competitor['location'];

        if ($my_website == $company_website && $my_location == $location) {
            return;
        }

        $data_request = $this->request_data_competitors($language, $location, $company_website);

        $result = $data_request['result'];
        $rank_history = $data_request['rank_history'];
        $backlinks_result = $data_request['backlinks_result'];
        $next_update = $data_request['next_update'];

        $search_terms = [];
        if (!empty($result['data'])) {
            foreach ($result['data'] as $terms) {
                $search_terms[random_int(100000000, 999999999)] = $terms;
            }
        }

        $slug = $company_website . $slugLocation;
        $tax = self::COMPETITORS_AS_CATEGORIES_KEY;
        $term_exist = get_term_by('slug', $slug, $tax);
        if ($term_exist && $term_exist->term_id != $our_competitor_id) {
            wp_delete_term($term_exist->term_id, $tax);
        }

        $this->competitors_fields($our_competitor_id, $next_update, $company_website, $slugLocation, $location, $search_terms, $backlinks_result, $rank_history);

    }

    public function reorder_positions_stats($positions)
    {
        $reordered = [];
        if (!empty($positions)) {

            $pos_1 = 0;
            $pos_2_3 = 0;
            $pos_4_10 = 0;
            $pos_11_20 = 0;
            $pos_21_30 = 0;
            $pos_31_40 = 0;
            $pos_41_50 = 0;
            $pos_51_60 = 0;
            $pos_61_70 = 0;
            $pos_71_80 = 0;
            $pos_81_90 = 0;
            $pos_91_100 = 0;

            foreach ($positions as $i => $position) {
                if (is_array($position)) {
                    $metrics_updated = [];
                    foreach ($position['metrics'] as $key => $metrics) {
                        if ($key == 'pos_1') {
                            $pos_1 = $metrics;
                        } else if ($key == 'pos_2_3') {
                            $pos_2_3 = $metrics;
                        } else if ($key == 'pos_4_10') {
                            $pos_4_10 = $metrics;
                        } else if ($key == 'pos_11_20') {
                            $pos_11_20 = $metrics;
                        } else if ($key == 'pos_21_30') {
                            $pos_21_30 = $metrics;
                        } else if ($key == 'pos_31_40') {
                            $pos_31_40 = $metrics;
                        } else if ($key == 'pos_41_50') {
                            $pos_41_50 = $metrics;
                        } else if ($key == 'pos_51_60') {
                            $pos_51_60 = $metrics;
                        } else if ($key == 'pos_61_70') {
                            $pos_61_70 = $metrics;
                        } else if ($key == 'pos_71_80') {
                            $pos_71_80 = $metrics;
                        } else if ($key == 'pos_81_90') {
                            $pos_81_90 = $metrics;
                        } else if ($key == 'pos_91_100') {
                            $pos_91_100 = $metrics;
                        }

                        $positions[$i]['metrics']['pos_1_3'] = intval($pos_1) + intval($pos_2_3);
                        $positions[$i]['metrics']['pos_4_10'] = intval($pos_4_10);
                        $positions[$i]['metrics']['pos_11_30'] = intval($pos_11_20) + intval($pos_21_30);
                        $positions[$i]['metrics']['pos_31_50'] = intval($pos_31_40) + intval($pos_41_50);
                        $positions[$i]['metrics']['pos_51_100'] = intval($pos_51_60) + intval($pos_61_70) + intval($pos_71_80) + intval($pos_81_90) + intval($pos_91_100);

                        unset($positions[$i]['metrics']['pos_1']);
                        unset($positions[$i]['metrics']['pos_2_3']);
                        unset($positions[$i]['metrics']['pos_11_20']);
                        unset($positions[$i]['metrics']['pos_21_30']);
                        unset($positions[$i]['metrics']['pos_31_40']);
                        unset($positions[$i]['metrics']['pos_41_50']);
                        unset($positions[$i]['metrics']['pos_51_60']);
                        unset($positions[$i]['metrics']['pos_61_70']);
                        unset($positions[$i]['metrics']['pos_71_80']);
                        unset($positions[$i]['metrics']['pos_81_90']);
                        unset($positions[$i]['metrics']['pos_91_100']);

                    }
                }

                $reordered = $positions;
            }

        }

        return $reordered;
    }

    public function validate_positions_real_terms_count($competitor_id = 0)
    {

        if (!$competitor_id) {
            $competitor_id = $this->our_own_website_index();
        }

        $historical_rank = $this->get_competitor_field_val($competitor_id, 'historical_rank');
        $search_terms = $this->get_competitor_field_val($competitor_id, 'search_terms');
        $last_metrics = !empty($historical_rank[0]['metrics']) ? $historical_rank[0]['metrics'] : [];

        $pos_1_3 = !empty($last_metrics['pos_1_3']) ? $last_metrics['pos_1_3'] : 0;
        $pos_4_10 = !empty($last_metrics['pos_4_10']) ? $last_metrics['pos_4_10'] : 0;
        $pos_11_30 = !empty($last_metrics['pos_11_30']) ? $last_metrics['pos_11_30'] : 0;
        $pos_31_50 = !empty($last_metrics['pos_31_50']) ? $last_metrics['pos_31_50'] : 0;
        $pos_51_100 = !empty($last_metrics['pos_51_100']) ? $last_metrics['pos_51_100'] : 0;

        $real_1_3 = [];
        $real_4_10 = [];
        $real_11_30 = [];
        $real_31_50 = [];
        $real_51_100 = [];

        foreach ((array)$search_terms as $term) {
            $position = $term['position'] ?? 0;
            $position = is_string($position) ? intval($position) : $position;
            if ($position >= 1 && $position <= 3) {
                $real_1_3[] = $position;
            }
            if ($position >= 4 && $position <= 10) {
                $real_4_10[] = $position;
            }
            if ($position >= 11 && $position <= 30) {
                $real_11_30[] = $position;
            }
            if ($position >= 31 && $position <= 50) {
                $real_31_50[] = $position;
            }
            if ($position >= 51 && $position <= 100) {
                $real_51_100[] = $position;
            }
        }

        if ($pos_1_3 < count($real_1_3)) {
            $historical_rank[0]['metrics']['pos_1_3'] = count($real_1_3);
        }

        if ($pos_4_10 < count($real_4_10)) {
            $historical_rank[0]['metrics']['pos_4_10'] = count($real_4_10);
        }

        if ($pos_11_30 < count($real_11_30)) {
            $historical_rank[0]['metrics']['pos_11_30'] = count($real_11_30);
        }

        if ($pos_31_50 < count($real_31_50)) {
            $historical_rank[0]['metrics']['pos_31_50'] = count($real_31_50);
        }

        if ($pos_51_100 < count($real_51_100)) {
            $historical_rank[0]['metrics']['pos_51_100'] = count($real_51_100);
        }

        update_term_meta($competitor_id, 'historical_rank', $historical_rank);
    }

    public function validate_positions_all_competitors_ajax()
    {
        check_ajax_referer(SeoaicAjaxValidation::ACTION_STRING);

        $status = $this->validate_positions_all_competitors();

        wp_send_json([
            'status' => $status,
        ]);
    }

    public function validate_positions_all_competitors(): bool
    {
        $status = false;

        $competitors = $this->get_competitors();

        foreach ($competitors as $competitor) {
            $this->validate_positions_real_terms_count($competitor->term_id);
            $status = true;
        }

        return $status;
    }

    /**
     * Remove Term
     */
    public function Remove_Term()
    {
        check_ajax_referer(SeoaicAjaxValidation::ACTION_STRING);

        if (empty($_REQUEST['item_id'])) {
            wp_die();
        }

        $ID = $_REQUEST['competitor_index'];
        $terms = explode(',', $_REQUEST['item_id']);
        $removed_terms = [];
        $search_terms = $this->get_search_terms($ID);

        foreach ($terms as $term) {
            $removed_terms[] = $search_terms[$term]['keyword'];
            unset($search_terms[$term]);
        }
        update_term_meta($ID, 'search_terms', $search_terms);

        SEOAICAjaxResponse::alert('Competitor removed: ' . implode(',', $removed_terms))->wpSend();

    }

    /**
     * Remove Competitor
     */
    public function Remove_Competitor()
    {
        check_ajax_referer(SeoaicAjaxValidation::ACTION_STRING);

        if (empty($_REQUEST['item_id'])) {
            wp_die();
        }

        $competitors_ids = explode(',', $_REQUEST['item_id']);

        foreach ($competitors_ids as $id) {
            $name = get_term_by('id', $id, self::COMPETITORS_AS_CATEGORIES_KEY)->name;
            $result = wp_delete_term($id, self::COMPETITORS_AS_CATEGORIES_KEY);

            if (is_wp_error($result)) {
                SEOAICAjaxResponse::error('Error:' . $result->get_error_message())->wpSend();
            } else {
                if (count($competitors_ids) == 1) {
                    SEOAICAjaxResponse::alert('Competitor removed: ' . $name)->wpSend();
                }
            }
        }

        SEOAICAjaxResponse::alert('Competitors removed')->wpSend();

    }

    /**
     * HTML Competitors page top tabs
     */
    public function Competitors_Page_Top_Tabs_HTML(): string
    {
        global $SEOAIC_OPTIONS;

        $location = $this->get_the_location_param();
        $competitors = $this->get_competitors($location);

        $m_0 = !$competitors ? 'ml-0' : '';

        $my_site = $this->seoaic_company_website_url();

        $html = '';
        $select = '';
        $lastUpdatedTimestamp = self::getLastUpdateTimestamp();
        $manualNextTime = $lastUpdatedTimestamp + self::NEXT_UPDATE_DAYS;
        $refreshDisabledAttr = time() > $manualNextTime ? '' : 'disabled';
        $lastUpdatedStr = !empty($lastUpdatedTimestamp) ? ' ' . esc_html__("Data can be refreshed again on: ", 'seoaic') . gmdate('d/m/Y H:i e', $manualNextTime) : '';

        if (count($competitors) > 0) :
            $all = false;

            $html .= '<div class="competitors-watch dragscroll">';

            if (count($competitors) > 0) :
                $all = true;

                $html .= '<a class="active" href="#" data-index="-1" data-action="seoaic_Competitors_Compare_Section_HTML">
                            <span class="competitor active">' . esc_html__('All Competitors', 'seoaic') . '</span>
                          </a>';

                $select .= '<option value="-1">' . esc_html__('All Competitors', 'seoaic') . '</option>';
            endif;

            $i = 0;
            foreach ($competitors as $competitor) :
                $id = $competitor->term_id;
                $url = $this->get_competitor_field_val($id, 'url');
                $url_live = $this->get_competitor_field_val($id, 'url_live');
                $url_display = $this->get_competitor_field_val($id, 'url_display');
                $location = $this->get_competitor_field_val($id, 'location');

                $active = '';
                if ($id === 0 && !$all) {
                    $active = 'class="active"';
                }

                if ($url_live) :

                    $our_website = $url_live == $my_site ? 'our_website' : '';
                    $post_id = $url_live == $my_site ? '' : esc_attr($url);

                    $html .=
                        '<a class="' . esc_attr($our_website) . '" ' . $active . ' href="#" data-index="' . esc_attr($id) . '" data-action="seoaic_Competitors_Compare_Section_HTML" data-location="' . esc_html($location) . '">
                            <span class="competitor">
                                ' . esc_html($url_display) . '
                            </span>
                            <span data-post-id="' . esc_attr($post_id) . '"></span>
                        </a>';

                    $select .= '<option value="' . esc_attr($id) . '">' . esc_html($url_display) . '</option>';

                endif;
                $i++;
            endforeach;
            $html .= '</div>';
        endif;

        if (count($competitors) > 0) :
            $html .= '
                    <select class="select2-competitors">
                      ' . $select . '
                    </select>';
        endif;

        $migrated_competitors = isset($SEOAIC_OPTIONS['migrated_competitors']) ? json_encode($SEOAIC_OPTIONS['migrated_competitors']) : '';

        $html .= '<button title="Add new competitor"
                        data-title="' . esc_html__('Add a New Competitor', 'seoaic') . '"
                        type="button"
                        class="add-new-competitor-button competitor-button modal-button ' . esc_attr($m_0) . '"
                        data-action="seoaic_add_new_competitor"
                        data-modal="#seoaic-add-new-competitor"
                        data-mode="add"
                        data-form-callback="window_reload"
                >' . esc_html__('+ Add New', 'seoaic') . '
                    <div class="dn edit-form-items">
                        <input type="hidden" name="item_name" value="" data-label="' . esc_html__('Competitors’s Website', 'seoaic') . '">
                        <input type="hidden" name="action" value="seoaic_Add_New_Competitor">
                    </div>
                </button>';

        $html .= '<button data-title="Generate Competitor Content"
                        type="button"
                        class="generate-competitor-content-btn button-primary outline ml-auto modal-button"
                        data-selected="get-selected"
                        data-post-id=""
                        data-competitor-id=""
                        disabled="disabled"
                        data-modal="#seoaic-post-mass-creation-modal"
                        data-action="seoaic_Prepare_Article_Based_Search_Term"
                        data-form-callback="window_reload"
                        data-migrated-competitors="' . $migrated_competitors . '"
                >' . esc_html__('Generate Competitor Content', 'seoaic') . '
                    <div class="dn edit-form-items">
                        <input type="hidden" name="item_name" value=""
                               data-label="' . esc_html__('Generate Competitor Content. Ex: cup,table', 'seoaic') . '">
                        <input type="hidden" name="action" value="seoaic_Generate_Article_Based_Search_Term">
                    </div>
                </button>';

        $html .= '<button title="Add new competitor"
                        data-title="' . esc_html__('Compare', 'seoaic') . '"
                        type="button"
                        class="competitor-compare competitor-button modal-button ' . esc_attr($m_0) . '"
                        data-action="seoaic_compare_competitor"
                        data-modal="#competitors-compare"
                        data-mode="add"
                        data-form-callback="window_reload"
                        disabled="disabled"
                >' . esc_html__('Compare', 'seoaic') . '
                </button>';

        $html .= '<button type="button"
            ' . esc_attr($refreshDisabledAttr) . '
            title="' . esc_html__('Refresh data.', 'seoaic') . esc_attr($lastUpdatedStr) . '"
            class="seoaic-update-competitors seoaic-ajax-button seoaic-mr-20"
            data-action="seoaic_competitors_refresh_manual"
            data-callback="update_competitors_manual"
        ></button>';

        $html .= '<button title="Remove" disabled type="button"
                        class="seoaic-remove-main modal-button confirm-modal-button ml-0"
                        data-modal="#seoaic-confirm-modal"
                        data-action="seoaic_Remove_Term"
                        data-form-callback="window_reload"
                        data-content="' . esc_html__('Do you want to remove selected keywords?', 'seoaic') . '"
                        data-selected="get-selected"
                        data-post-id=""
                ></button>';

        return $html;
    }

    public function our_own_website_index()
    {

        global $SEOAIC_OPTIONS;

        $id = !isset($SEOAIC_OPTIONS['my_competitor_term_id']) ? 0 : $SEOAIC_OPTIONS['my_competitor_term_id'];

        if (!$id) {
            return 0;
        }

        return $id;
    }

    public function our_own_competitor_id($location)
    {

        $competitors = $this->get_competitors($location);
        $company_site = $this->seoaic_company_website_url();

        foreach ($competitors as $competitor) {
            $url_live = get_term_meta($competitor->term_id, 'url_live', true);
            if ($url_live === $company_site) {
                $id = $competitor->term_id;
            }
        }

        if (empty($id)) {
            return 0;
        }

        return $id;
    }

    public function our_own_website_url_for_competitors()
    {
        $our_website_term_id = $this->our_own_website_index();
        $url_live = $this->get_competitor_field_val($our_website_term_id, 'url_live');
        $location = $this->get_competitor_field_val($our_website_term_id, 'location');

        return [
            'my_website' => $url_live ?? '',
            'location' => $location ?? '',
            'index' => $our_website_term_id ?? 0
        ];
    }

    public function get_the_location_param()
    {
        if (isset($_GET['location'])) {
            $location = $_GET['location'];
        } else {
            $location = $this->seoaic_location();
        }

        return $location;
    }

    public function is_our_competitor_exists($location = '')
    {

        $exists = false;

        if (!$location) {
            $location = $this->get_the_location_param();
        }

        $competitors = $this->get_competitors($location);
        $company_site = $this->seoaic_company_website_url();

        foreach ($competitors as $competitor) {
            $url_location = get_term_meta($competitor->term_id, 'location', true);
            $url_live = get_term_meta($competitor->term_id, 'url_live', true);
            if ($url_location === $location && $url_live === $company_site) {
                $exists = true;
                break;
            }
        }

        return $exists;
    }

    public function insert_my_competitor_term()
    {
        check_ajax_referer(SeoaicAjaxValidation::ACTION_STRING);

        global $SEOAIC_OPTIONS;

        $location = !empty($_REQUEST['seoaic_location']) ? $_REQUEST['seoaic_location'] : $_REQUEST['location'];

        if (!$this->is_our_competitor_exists($location)) {

            $SEOAIC_OPTIONS['competitors_locations_countries'][] = $location;
            update_option('seoaic_options', $SEOAIC_OPTIONS);

            $my_site = $this->seoaic_company_website_url();
            $_REQUEST['item_name'] = $my_site;
            $this->Add_New_Competitor($_REQUEST['item_name'], $location, 0, false, true);

        }
    }

    public function get_my_site_id($location = '')
    {

        if (!$location) {
            return 0;
        }

        $competitors = $this->get_competitors($location);
        $company_site = $this->seoaic_company_website_url();
        $id = 0;

        foreach ($competitors as $competitor) {

            $url_live = get_term_meta($competitor->term_id, 'url_live', true);

            if ($url_live === $company_site) {

                $id = $competitor->term_id;

                break;
            }

        }

        return $id;
    }

    public function delete_duplicated_competitors()
    {
        $terms = get_terms(array(
            'taxonomy' => self::COMPETITORS_AS_CATEGORIES_KEY,
            'hide_empty' => false,
        ));

        if (is_wp_error($terms) || empty($terms)) {
            return;
        }

        $term_names = array();

        foreach ($terms as $term) {
            $term_name = strtolower($term->name);
            if (!isset($term_names[$term_name])) {
                $term_names[$term_name] = $term->term_id;
            } else {
                wp_delete_term($term->term_id, self::COMPETITORS_AS_CATEGORIES_KEY);
            }
        }
    }

    public function Competitors_Compare_Section_HTML_Ajax()
    {
        check_ajax_referer(SeoaicAjaxValidation::ACTION_STRING);

        $this->Competitors_Compare_Section_HTML();
    }

    /**
     * Competitors Compare Section HTML
     */
    public function Competitors_Compare_Section_HTML(): string
    {

        $key = '';
        if (isset($_REQUEST['index'])) {
            $key = $_REQUEST['index'];
        }

        $location = $this->get_the_location_param();

        if (isset($_REQUEST['location'])) {
            $location = $_REQUEST['location'];
        }

        $competitors = $this->get_competitors($location);

        $html = '';
        if (!empty($competitors)) {

            $remove_link = '<a class="bulk-remove-competitors modal-button" data-form-callback="window_reload" data-modal="#seoaic-confirm-modal" data-action="seoaic_remove_competitor" data-content="Do you want to remove this competitors?" href="#">' . esc_html__('Remove selected', 'seoaic') . '</a>';

            $html = '<div class="row-line heading">
                    <div class="check">
                    <div class="check competitor-check-key">
                         <input class="competitor-check-all" name="competitor-check-all" type="checkbox">
                        ' . $remove_link . '
                    </div>
                    </div>
                    <div class="company-name"></div>
                    <div class="page"></div>
                    <div class="position">
                        ' . esc_html__('Position', 'seoaic') . esc_html(' 1-3') . '
                    </div>
                    <div class="position">
                        ' . esc_html__('Position', 'seoaic') . esc_html(' 4-10') . '
                    </div>
                    <div class="position">
                        ' . esc_html__('Position', 'seoaic') . esc_html(' 11-30') . '
                    </div>
                    <div class="position">
                        ' . esc_html__('Position', 'seoaic') . esc_html(' 31-50') . '
                    </div>
                    <div class="position">
                        ' . esc_html__('Position', 'seoaic') . esc_html(' 51-100') . '
                    </div>
                    <div class="open-all-positions"></div>
                    <div class="delete"></div>
                </div>';

            foreach ((array)$competitors as $competitor) {

                $my_site = $this->seoaic_company_website_url();
                //$first_index = $this->our_own_website_index();
                $first_index = $this->our_own_competitor_id($location);

                $id = $competitor->term_id;

                if ($key && $key != -1 && $id != $first_index && $id != $key) {
                    continue;
                }

                $html .= $this->competitor_card_HTML($id, $my_site);

            }
        }

        if ($key) {
            wp_send_json($html);
        }

        return $html;

    }

    public function competitor_card_HTML($id, $my_site)
    {

        $url = get_term_meta($id, 'url', true);
        $url_display = get_term_meta($id, 'url_display', true);
        $url_live = get_term_meta($id, 'url_live', true);
        $next_update = get_term_meta($id, 'next_update', true);
        $my_website = $this->our_own_website_index() == $id;

        $highlight = '';
        $html = '';
        $siteURL = empty($url_display) ? $url : $url_display;
        $checked = '';

        if ($my_site == $url_live) {
            $highlight = 'highlight';
            $siteURL = $url_live;
            $remove_id = '';
            $checked = ' checked="checked"';
            $my_website = ' disabled="disabled" ';
        } else {
            $remove_id = $url;
            $my_website = '';
        }

        $my_website = !empty($my_website) ? ' disabled="disabled" ' : '';
        $html .= '<div class="row-line ' . esc_attr($highlight) . '" data-element-id="' . esc_attr($id) . '" data-last-updated="' . esc_attr(esc_html__('Updated at:', 'seoaic') . ' ' . date("d F Y H:i:s", $next_update - self::NEXT_UPDATE_DAYS)) . '">
                            <div class="check competitor-check-key">
                                <input ' . $my_website . $checked . ' class="competitor-check-key" name="competitor-check-key" type="checkbox" data-competitor="' . esc_attr($id) . '" data-item="' . esc_attr($url_live) . '">
                            </div>
                            <div class="company-name"><span data-i="' . esc_attr($id) . '">' . esc_html($siteURL) . '</span></div>

                                ' . $this->competitor_card_data_HTML($id) . '

                            <div class="delete column-key">
                                <button title="' . esc_html__('Remove', 'seoaic') . '" type="button" class="seoaic-remove modal-button confirm-modal-button"
                                        class="remove modal-button"
                                        title="' . esc_html__('Remove competitor', 'seoaic') . '"
                                        data-post-id="' . esc_attr($id) . '"
                                        data-modal="#seoaic-confirm-modal"
                                        data-action="seoaic_remove_competitor"
                                        data-form-callback="window_reload"
                                        data-content="' . esc_html__('Do you want to remove this competitor:', 'seoaic') . ' ' . esc_attr($remove_id) . '?"
                                ></button>
                            </div>
                        </div>';

        return $html;
    }

    private function competitor_card_data_HTML($id)
    {

        $historical_rank = get_term_meta($id, 'historical_rank', true);
        $backlinks = get_term_meta($id, 'backlinks', true);
        if (isset($historical_rank[0]['metrics'])) {
            $metrics = $historical_rank[0]['metrics'];
        }
        $pos_1 = empty($metrics['pos_1_3']) ? '-' : $metrics['pos_1_3'];
        $pos_2_3 = empty($metrics['pos_4_10']) ? '-' : $metrics['pos_4_10'];
        $pos_4_10 = empty($metrics['pos_11_30']) ? '-' : $metrics['pos_11_30'];
        $pos_11_20 = empty($metrics['pos_31_50']) ? '-' : $metrics['pos_31_50'];
        $pos_21_30 = empty($metrics['pos_51_100']) ? '-' : $metrics['pos_51_100'];
        $count = intval($pos_1) + intval($pos_2_3) + intval($pos_4_10) + intval($pos_11_20) + intval($pos_21_30);
        $backlinks = empty($backlinks) ? '-' : intval($backlinks);
        $etv = empty($metrics['etv']) ? 0 : $metrics['etv'];
        $rank_history = empty($historical_rank) ? [] : $historical_rank;
        $estimated_paid_traffic_cost = empty($metrics['estimated_paid_traffic_cost']) ? 0 : $metrics['estimated_paid_traffic_cost'];
        $inactive = !empty($metrics) ? '' : 'disabled';
        $etv = $etv ? number_format(round($etv), 0, ' ', ' ') : '-';
        $estimated_paid_traffic_cost = $estimated_paid_traffic_cost ? esc_html('$ ') . number_format(round($estimated_paid_traffic_cost), 2, ',', ' ') : '-';


        return '<div class="page">
                    <div class="inner">
                        <div class="key">' . esc_html__('Estimated traffic volume:', 'seoaic') . '</div>
                        <div class="value">' . esc_html($etv) . '</div>
                        <div class="key">' . esc_html__('Estimated traffic worth:', 'seoaic') . '</div>
                        <div class="value">' . esc_html($estimated_paid_traffic_cost) . '</div>
                        <div class="key">' . esc_html__('Total keywords ranked:', 'seoaic') . '</div>
                        <div class="value">' . esc_html($count) . '</div>
                        <div class="key">' . esc_html__('Backlinks count:', 'seoaic') . '</div>
                        <div class="value">' . number_format(intval($backlinks)) . '</div>
                    </div>
                </div>
                <div class="position pos_1">
                    ' . esc_html($pos_1) . '
                </div>
                <div class="position pos_2_3">
                    ' . esc_html($pos_2_3) . '
                </div>
                <div class="position pos_4_10">
                    ' . esc_html($pos_4_10) . '
                </div>
                <div class="position pos_11_20">
                    ' . esc_html($pos_11_20) . '
                </div>
                <div class="position pos_21_30">
                    ' . esc_html($pos_21_30) . '
                </div>
                <div class="open-all-positions">
                    <a href="#" data-modal="#ranking-modal"
                       data-ranking=""
                       class="modal-button ' . esc_attr($inactive) . '"
                       data-chart-type="area"
                       data-chart-id="#chart_competitors_positions"
                       data-charts="' . esc_attr(json_encode($rank_history)) . '"
                       data-charts-traffic="' . json_encode($rank_history) . '"
                       >' . esc_html__('show historical graphs', 'seoaic') . '</a>
                       <div class="loader-ellipsis small position-absolute"></div>
                </div>';
    }

    /**
     * Terms pagination HTML
     */
    public function terms_pagination(array $search_terms, int $page_size, int $page)
    {
        $total_records = count($search_terms);
        $total_pages = ceil($total_records / $page_size);
        if ($page > $total_pages) {
            $page = $total_pages;
        }
        if ($page < 1) {
            $page = 1;
        }
        $offset = ($page - 1) * $page_size;
        $search_terms = array_slice($search_terms, $offset, $page_size, true);
        // page links
        $N = min($total_pages, 4);
        $pages_links = array();
        $tmp = $N;
        if ($tmp < $page || $page > $N) {
            $tmp = 2;
        }
        for ($i = 1; $i <= $tmp; $i++) {
            $pages_links[$i] = $i;
        }
        if ($page > $N && $page <= ($total_pages - $N + 2)) {
            for ($i = $page - 3; $i <= $page + 3; $i++) {
                if ($i > 0 && $i < $total_pages) {
                    $pages_links[$i] = $i;
                }
            }
        }
        $tmp = $total_pages - $N + 1;
        if ($tmp > $page - 2) {
            $tmp = $total_pages - 1;
        }
        for ($i = $tmp; $i <= $total_pages; $i++) {
            if ($i > 0) {
                $pages_links[$i] = $i;
            }
        }
        $prev = 0;
        $pagination = '';
        $per_page_wrap = '';
        $prev_page = '';
        if (!empty($search_terms) || intval($total_pages) == 1) {
            $pagination .= '<div class="seoaic-pagination">';
            foreach ($pages_links as $key => $p) {
                if (count($pages_links) > 1) {
                    if (($p - $prev) > 1) {
                        $pagination .= '<a class="page-numbers pe-none" style="pointer-events:none;" href="#">' . esc_html('...') . '</a>';
                    }
                    $prev = $p;
                    $style_active = '';
                    if ($p == $page) {
                        $style_active = 'style="color: #fff;background-color: #100717;pointer-events:none;"';
                    }
                    if ($key === array_key_first($pages_links) && $page > 1) {
                        $prev = $page - 1;
                        $pagination .= '<a class="page-numbers" href="#" data-page="' . esc_attr($prev) . '">' . esc_html__('Prev', 'seoaic') . '</a>';
                    }
                    $pagination .= '<a class="page-numbers" ' . $style_active . ' href="#" data-page="' . esc_attr($p) . '">' . esc_html($p) . '</a>';
                    if ($key === array_key_last($pages_links) && $p !== $page) {
                        $next = $page + 1;
                        $pagination .= '<a class="page-numbers" href="#" data-page="' . esc_attr($next) . '">' . esc_html__('Next', 'seoaic') . '</a>';
                    }
                } else {
                    $pagination = '';
                }
            }
        } else {
            $pagination = '<div class="seoaic-pagination"><span class="empty">' . esc_html__('No terms found', 'seoaic') . '</span></div>';
        }

        $pagination .= '</div>';

        if ($total_records > $page_size) {
            $per_page = array(50, 100, 250, 500, 1000);
            $options = '';
            foreach ($per_page as $per) {
                $selected = (intval($per) === $page_size) ? 'selected' : '';
                $options .= '<option value="' . esc_attr($per) . '" ' . esc_attr($selected) . '>' . esc_html($per) . '</option>';
            }
            $label = '<span class="text-label">' . esc_html__('Per page', 'seoaic') . '</span>';
            $select = '<select class="form-select" data-page="1">' . $options . '</select>';

            $per_page_wrap .= $label . $select;
        }

        return [
            'pagination_html' => $pagination,
            'rows_array' => $search_terms,
            'per_page' => $per_page_wrap
        ];
    }

    public function sort_order_array($array, $key, $order = 'ASC')
    {
        $get_keys = array_keys($array);

        $wek = [];
        foreach ($array as $index => $row) {
            $wek[$index] = $row[$key];
        }

        $order = ($order == 'DESC') ? SORT_DESC : SORT_ASC;

        array_multisort($wek, $order, $array, $get_keys);

        return array_combine($get_keys, $array);
    }

    public function Competitors_Search_Terms_HTML_Ajax()
    {
        check_ajax_referer(SeoaicAjaxValidation::ACTION_STRING);

        $this->Competitors_Search_Terms_HTML();
    }

    /**
     * Competitors Search Terms HTML
     */
    public function Competitors_Search_Terms_HTML(): string
    {
        $key = '';
        if (isset($_REQUEST['index'])) {
            $key = $_REQUEST['index'];
        }
        $page = !isset($_REQUEST['page']) ? 0 : $_REQUEST['page'];
        $per_page = !isset($_REQUEST['per_page']) ? 50 : intval($_REQUEST['per_page']);
        $keyword = !isset($_REQUEST['keyword']) ? '' : $_REQUEST['keyword'];
        $page_keyword = !isset($_REQUEST['page_keyword']) ? '' : $_REQUEST['page_keyword'];
        $my_rank = !isset($_REQUEST['my_rank']) ? 'all-rank-terms' : $_REQUEST['my_rank'];
        $rank_min = !isset($_REQUEST['rank-min']) ? 0 : intval($_REQUEST['rank-min']);
        $rank_max = !isset($_REQUEST['rank-max']) ? 0 : intval($_REQUEST['rank-max']);
        $search_vol_min = !isset($_REQUEST['search-vol-min']) ? 0 : intval($_REQUEST['search-vol-min']);
        $search_vol_max = !isset($_REQUEST['search-vol-max']) ? 0 : intval($_REQUEST['search-vol-max']);
        $order_name = !isset($_REQUEST['order_name']) ? 'position' : $_REQUEST['order_name'];
        $order = !isset($_REQUEST['order']) ? 'DESC' : $_REQUEST['order'];
        $search_terms = $this->get_search_terms($key);
        $searches = $this->get_search_terms_field_val($key, 'search_volume');
        $positions = $this->get_search_terms_field_val($key, 'position');
        $our_own_website_id = $this->our_own_website_index();

        $select_my_rank = '
        <select>
            <option value="all-rank-terms">' . esc_html__('All ranks', 'seoaic') . '</option>
            <option value="i-rank-with">' . esc_html__('I\'m ranking', 'seoaic') . '</option>
            <option value="i-dont-rank-with">' . esc_html__('I\'m not ranked', 'seoaic') . '</option>
        </select>';

        $my_website = $key == $our_own_website_id ? esc_html__('All ranks', 'seoaic') : $select_my_rank;

        $searches_min = $searches ? min($searches) : 0;
        $searches_min = intval($searches_min) ? $searches_min : 0;
        $searches_max = $searches ? max($searches) : 0;
        $searches_max = intval($searches_max) ? $searches_max : 0;
        $positions_min = $positions ? min($positions) : 0;
        $positions_min = intval($positions_min) ? $positions_min : 0;
        $positions_max = $positions ? max($positions) : 0;
        $positions_max = intval($positions_max) ? $positions_max : 0;

        $html = '';
        $pagination = '';

        if (!empty($search_terms)) {

            if (!$keyword && !$rank_min && !$rank_max && !$search_vol_min && !$search_vol_max && !$page && !$page_keyword) {
                $html .=
                    '<div class="row-line heading">
                        <div class="check">
                            <input name="seoaic-select-all-keywords" type="checkbox">
                        </div>
                        <div class="keyword seoai-filterable seoai-filter-text left-opener" data-name="keyword" data-placeholder="' . esc_html__('Type keyword', 'seoaic') . '" data-sort="keyword" data-competitor-index="' . esc_attr($key) . '">
                            ' . esc_html__('Keyword', 'seoaic') . '
                            <span class="sorting">
                                <span class="asc">&#9662</span>
                                <span class="desc">&#9662</span>
                            </span>
                        </div>
                        <div class="page seoai-filterable seoai-filter-text left-opener" data-sort="page_keyword" data-placeholder="' . esc_html__('Search url or meta description', 'seoaic') . '" data-competitor-index="' . esc_attr($key) . '">
                            ' . esc_html__('Page', 'seoaic') . '
                        </div>
                        <div class="rank seoai-filterable seoai-filter-num"  data-min="' . esc_attr($positions_min) . '" data-max="' . esc_attr($positions_max) . '" data-sort="rank" data-competitor-index="' . esc_attr($key) . '">

                            ' . $my_website . '
                            <span class="sorting">
                                <span class="asc">▾</span>
                                <span class="desc">▾</span>
                            </span>
                        </div>
                        <div class="search-vol seoai-filterable seoai-filter-num seoai-opener-extra-height" data-min="' . esc_attr($searches_min) . '" data-max="' . esc_attr($searches_max) . '" data-sort="search-vol" data-competitor-index="' . esc_attr($key) . '">
                           ' . esc_html__('Search Volume', 'seoaic') . '
                            <span class="sorting">
                                <span class="asc">&#9662</span>
                                <span class="desc">&#9662</span>
                            </span>
                        </div>
                        <div class="difficulty">
                            ' . esc_html__('Difficulty', 'seoaic') . '
                        </div>
                        <div class="value-key ETC">
                            ' . esc_html__('ETC', 'seoaic') . '
                        </div>
                        <div class="value-key ETV">
                            ' . esc_html__('ETV', 'seoaic') . '
                        </div>
                        <div class="delete"></div>
                    </div>';
            }

            if ($keyword || $rank_min || $rank_max || $search_vol_min || $search_vol_max || $page_keyword) {

                $filter = [
                    'keyword' => $keyword,
                    'page' => $page_keyword,
                    'position_min' => $rank_min,
                    'position_max' => $rank_max,
                    'search_vol_min' => $search_vol_min,
                    'search_vol_max' => $search_vol_max,
                    'my_rank' => $my_rank
                ];

                $search_terms = array_filter($search_terms, function ($item) use ($filter) {

                    if (strlen(trim(preg_replace('/\xc2\xa0/', '', $filter['keyword']))) == 0) {
                        $filter['keyword'] = '';
                    }
                    $word = !is_array($item['keyword']) ? $item['keyword'] : implode(' ', $item['keyword']);


                    if (strlen(trim(preg_replace('/\xc2\xa0/', '', $filter['page']))) == 0) {
                        $filter['page'] = '';
                    }
                    $page_word = !is_array($item['page']) ? $item['page'] : implode(' ', $item['page']);


                    $rank = intval($item['my_rank']);

                    return
                        ($filter['page'] == '' || strpos($page_word, trim($filter['page'])) !== false)
                        &&
                        ($filter['keyword'] == '' || strpos($word, trim($filter['keyword'])) !== false)
                        &&
                        (($filter['search_vol_min'] == 0 || $item['search_volume'] >= $filter['search_vol_min']) && ($filter['search_vol_max'] == 0 || $item['search_volume'] <= $filter['search_vol_max']))
                        &&
                        (($filter['position_min'] == 0 || intval($item['position']) >= $filter['position_min']) && ($filter['position_max'] == 0 || intval($item['position']) <= $filter['position_max']))
                        &&
                        (
                            ($filter['my_rank'] === 'all-rank-terms')
                            ||
                            ($filter['my_rank'] === 'i-dont-rank-with' && ($rank == 0))
                            ||
                            ($filter['my_rank'] === 'i-rank-with' && intval($item['my_rank']) > 0)
                        );
                });

            }

            if ($order_name) {
                switch ($order_name) {
                    case 'rank':
                        $order_name = 'position';
                        break;
                    case 'search-vol':
                        $order_name = 'search_volume';
                        break;
                }
                $search_terms = $this->sort_order_array($search_terms, $order_name, $order);
            }

            if (!$page) {
                $page = 1;
            }

            $terms_pagination = $this->terms_pagination($search_terms, $per_page, intval($page));
            $search_terms = $terms_pagination['rows_array'];
            $pagination = !empty($terms_pagination['pagination_html']) ? $terms_pagination['pagination_html'] : '';

            foreach ($search_terms as $i => $term) {

                $loading = $term['my_rank'] === -1 ? ' view loading' : '';
                $my_rank = !empty($term['my_rank']) && $term['my_rank'] > 0 ? $term['my_rank'] : ($loading ? '' : esc_html__('Show ', 'seoaic'));
                $my_rank_class = !empty($term['my_rank']) && $term['my_rank'] > 0 ? '' : 'empty' . $loading;
                $updated = !empty($term['my_rank']) ? 'ready' : '';
                $status = $loading ? ' term-ready-to-update running' : '';

                $html .=
                    '<div class="row-line">
                        <div class="check"><input class="seoaic-check-key" name="seoaic-check-key" type="checkbox" data-keyword="' . esc_attr($i) . '" data-term="' . esc_attr($term['keyword']) . '">
                        </div>
                        <div class="keyword" data-i="' . esc_attr($i) . '"><span>' . esc_html($term['keyword']) . '</span>' . $this->GetCreatedPosts(740994, 697953951) . '</div>
                        <div class="page">
                            ' . (!empty($term['page']) ? '<a href="' . esc_attr($term['page']) . '" target="_blank">' . esc_html($term['page']) . '</a>' : '-') . '
                            ' . (!empty($term['meta_description']) ? '<span>' . esc_html($term['meta_description']) . '</span>' : '-') . '
                        </div>
                        <div class="rank ' . esc_attr($updated . $status) . '" data-term="' . esc_attr($i) . '" data-competitor="' . esc_attr($key) . '">
                            ' . (!empty($term['position']) ? '<a href="' . esc_attr($term['page']) . '" target="_blank">' . esc_html($term['position']) . '</a>' : '-') . '
                            <div class="' . esc_attr($my_rank_class) . '"><span>' . esc_html($my_rank) . '</span>' . esc_html__(' my rank', 'seoaic') . '</div>
                        </div>
                        <div class="search-vol">' . (!empty($term['search_volume']) ? esc_html($term['search_volume']) : '-') . '</div>

                        <div class="difficulty ' . (!empty($term['difficulty']) ? esc_html($term['difficulty']) : '-') . '">
                            <span>' . (!empty($term['difficulty']) ? esc_html($term['difficulty']) : '-') . '</span>
                        </div>

                        <div class="value-key ETC">
                            <span>' . (!empty($term['etc']) ? round(intval($term['etc'])) : '-') . '</span>
                        </div>

                        <div class="value-key ETV">
                            <span>' . (!empty($term['etv']) ? round(intval($term['etv'])) : '-') . '</span>
                        </div>

                        <div class="delete column-key">
                            <button title="' . esc_html__('Remove', 'seoaic') . '" type="button" class="seoaic-remove modal-button confirm-modal-button"
                                data-modal="#seoaic-confirm-modal"
                                data-action="seoaic_Remove_Term"
                                data-form-callback="window_reload"
                                data-content="' . esc_html__('Do you want to remove this keyword?', 'seoaic') . '"
                                data-post-id="' . esc_attr($term['keyword']) . '"
                                ></button>
                        </div>
                    </div>';

            }
        } else {
            if ($key != -1 and $key != '') {
                $html .= '<div class="no-search-terms-found">' . esc_html__('No Search Terms Found', 'seoaic') . '<span></span></div>';
            }
        }

        if ($key) {
            wp_send_json(
                [
                    'html' => $html,
                    'pagination' => $pagination,
                    'per_page' => !empty($terms_pagination) ? $terms_pagination['per_page'] : ''
                ]
            );
        }

        return $html;

    }

    /**
     * Get created posts with Search term
     * string $key
     * string $value
     */
    public function GetCreatedPosts($competitor, $term)
    {

        $args = [
            'post_status' => ['publish', 'draft', 'future'],
            'meta_query' => [
                'relation' => 'AND',
                [
                    'key' => 'seoai_competitor_index',
                    'value' => intval($competitor),
                ],
                [
                    'key' => 'seoai_term_index',
                    'value' => intval($term),
                ],
            ],
        ];

        $query = get_posts($args);
        $count = count($query);
        $label = $count == 1 ? esc_html__(' post created', 'seoaic') : esc_html__(' posts created', 'seoaic');
        $modal = $count < 1 ? '#generate-ideas' : '#search-terms-posts';
        $posts = '';
        $list_posts = [];
        foreach ($query as $post) {
            $title = $post->post_title;
            $id = $post->ID;
            $status = $post->post_status;
            $link = $status == 'publish' ? get_the_permalink($id) : get_edit_post_link($id);
            $type = $status == 'publish' ? '' : '(' . $status . ')';

            $list_posts[] = [
                "title" => $title,
                "id" => $id,
                "link" => $link,
                "type" => $type
            ];
        }
        if ($count > 0) {
            $posts .= '<a href="#" href="#" data-action="seoaic_generate_ideas" data-modal="' . esc_attr($modal) . '" class="modal-button confirm-modal-button" data-content="' . esc_attr(json_encode($list_posts)) . '" data-modal-title="' . esc_html__('Created posts', 'seoaic') . '">' . esc_html($count . $label) . '</a>';
        }

        return $posts;
    }

    public function set_values_my_rank_in_progress(): void
    {
        check_ajax_referer(SeoaicAjaxValidation::ACTION_STRING);

        if (!isset($_REQUEST['term'])) {
            wp_die();
        }

        $term = $_REQUEST['term'];
        $index = $_REQUEST['index'];

        $this->update_competitors_search_term_field($index, $term, 'my_rank', -1);

        wp_send_json([
            'status' => true
        ]);
    }

    public function request_my_rank_value($competitor_id, $term_index, $term_keyword, $return = false)
    {
        global $SEOAIC_OPTIONS, $SEOAIC;

        $language = $this->seoaic_language();
        $location = $this->seoaic_location();
        $our_own_website_url = $this->our_own_website_url_for_competitors();

        $data = [
            'email' => $SEOAIC_OPTIONS['seoaic_api_email'],
            'token' => $SEOAIC_OPTIONS['seoaic_api_token'],
            'language' => $language,
            'location' => $location,
            'target' => $our_own_website_url['my_website'],
            'limit' => 100,
            'add_terms' => $term_keyword,
        ];

        $result = $SEOAIC->curl->init('api/ai/rank-search-terms', $data, true, true, true);

        $my_rank = !isset($result['data'][0]['position']) ? '—' : $result['data'][0]['position'];

        $this->update_competitors_search_term_field($competitor_id, $term_index, 'my_rank', $my_rank);

        if ($return) {
            return $my_rank;
        }
    }

    public function Check_Terms_Update_Progress()
    {
        check_ajax_referer(SeoaicAjaxValidation::ACTION_STRING);

        if (!isset($_REQUEST['term'])) {
            wp_die();
        }

        $competitor_id = $_REQUEST['index'];
        $term_index = $_REQUEST['term'];

        $search_terms = $this->get_search_terms($competitor_id);
        $term_keyword = $search_terms[$term_index]['keyword'];

        $html = [];

        $get_my_rank = $this->request_my_rank_value($competitor_id, $term_index, $term_keyword, true);

        $loading = $get_my_rank === -1 ? ' view loading' : '';
        $my_rank = !empty($get_my_rank) && $get_my_rank > 0 ? $get_my_rank : ($loading ? '' : esc_html__('Show ', 'seoaic'));
        $my_rank_class = !empty($get_my_rank) && $get_my_rank > 0 ? '' : 'empty' . $loading;
        $updated = !empty($get_my_rank) ? 'ready' : '';
        $status = $loading ? ' term-ready-to-update running' : '';

        if (!empty($term_index)) {
            $html = [
                'html' => '<div class="' . esc_attr($my_rank_class) . '" data-i="' . esc_attr($term_index) . '"><span>' . esc_html($my_rank) . '</span>' . esc_html__(' my rank', 'seoaic') . '</div>',
                'index_term' => $term_index,
                'index_comp' => $competitor_id,
                'updated' => $updated,
                'status' => $status,
            ];
        }

        if ($competitor_id) {
            wp_send_json([
                'status' => true,
                'html' => $html
            ]);
        }

    }

    public function recursive_get_array_vlues($array, &$result)
    {
        foreach ($array as $key => $value) {
            if (is_array($value)) {
                $this->recursive_get_array_vlues($value, $result);
            } elseif ($key === 'text' || $key === 'h_title') {
                $result[] = $value;
            }
        }
    }

    private function seoaic_get_external_content($url)
    {
        global $SEOAIC_OPTIONS, $SEOAIC;

        $plain_text = [];

        $data = [
            'email' => $SEOAIC_OPTIONS['seoaic_api_email'],
            'token' => $SEOAIC_OPTIONS['seoaic_api_token'],
            'url' => $url,
        ];

        $response = $SEOAIC->curl->init('api/ai/content-parsing', $data, true, true, true);

        $this->recursive_get_array_vlues($response, $plain_text);

        return implode(' ', $plain_text);
    }

    public function competitor_content_language_selection()
    {
        if (!empty($_GET['page']) && $_GET['page'] === 'seoaic-competitors') {
            return $this->seoaic->multilang->get_multilang_checkboxes();
        }

        return false;
    }

    /**
     * Prepare Article Based Search Term
     */
    public function Prepare_Article_Based_Search_Term()
    {
        check_ajax_referer(SeoaicAjaxValidation::ACTION_STRING);

        global $SEOAIC;

        $id = !isset($_REQUEST['competitor']) ? '' : $_REQUEST['competitor'];
        $terms = !isset($_REQUEST['idea-mass-create']) ? [] : $_REQUEST['idea-mass-create'];
        $terms = !is_array($terms) ? [$terms] : $terms;
        $created_ideas = [];

        foreach ($terms as $term) {

            $search_terms = $this->get_search_terms($id);
            $term_keyword = $search_terms[intval($term)]['keyword'];
            $source_page = $search_terms[intval($term)]['page'];

            $source_content = !empty($this->seoaic_get_external_content($source_page)) ? $this->seoaic_get_external_content($source_page) : $term_keyword;

            $source_data = [
                'term' => $term_keyword,
                'source_content' => $source_content
            ];

            $IDs = $SEOAIC->ideas->generate(true, 1, $source_content, $term_keyword);

            $collect_ids[] = $IDs;

            foreach ($IDs as $ID) {
                update_post_meta($ID, 'seoaic_idea_source', $source_data);
            }

        }

        $mergedIDs = array_merge(...$collect_ids);

        $SEOAIC->posts->postsMassGenerate($mergedIDs);

        wp_send_json([
            'competitor' => $id,
            'term' => $terms,
            'status' => 'success',
        ]);

    }

    /**
     * Slugify string
     */
    public function Slug($text)
    {
        $text = preg_replace('~[^\pL\d]+~u', '_', $text);
        $text = trim($text, '-');
        $text = preg_replace('~-+~', '_', $text);
        $text = strtolower($text);
        if (empty($text)) {
            return 'n-a';
        }
        return $text;
    }

    /**
     * Slugify URL
     * param $text string
     */
    public static function Slugify_url($text)
    {
        $text = trim($text, '/');
        if (!preg_match('#^http(s)?://#', $text)) {
            $text = 'http://' . $text;
        }
        $text = parse_url($text);
        $path = '';
        $text = preg_replace('/^www\./', '', $text['host']);
        $text = $text . $path;
        $text = preg_replace('~[^\pL\d.\/-]+~u', '', $text);
        $text = preg_replace("~\/(?!.*\/)(.*)~", '', $text);
        $text = trim($text, '');
        $text = strtolower($text);
        if (empty($text)) {
            return 'n-a';
        }
        return $text;
    }


    public function update_competitors_data_ajax()
    {
        check_ajax_referer(SeoaicAjaxValidation::ACTION_STRING);

        $this->update_competitors_data();
    }

    public function update_competitors_data()
    {

        global $SEOAIC_OPTIONS;

        $ready_to_update_competitors = [];

        $api = !empty($SEOAIC_OPTIONS['seoaic_api_email']) ? $SEOAIC_OPTIONS['seoaic_api_email'] : false;

        $update = isset($_GET['update-competitors']) && $_GET['update-competitors'] == $api ? true : false;

        $time_update = $update ? (time() * 100) : time();

        $competitors = $this->get_competitors();

        foreach ($competitors as $competitor) {

            $ID = $competitor->term_id;
            $next_update = $this->get_competitor_field_val($ID, 'next_update');
            $historical_rank = $this->get_competitor_field_val($ID, 'historical_rank');
            $my_website = $this->get_competitor_field_val($ID, 'my_website');
            $url_live = $this->get_competitor_field_val($ID, 'url_live');
            $url = $this->get_competitor_field_val($ID, 'url');
            $location = $this->get_competitor_field_val($ID, 'location');
            if (
                isset($next_update) && intval($next_update) < $time_update
                or !isset($next_update)
                or !isset($historical_rank)
                or !isset($my_website)
                or intval($SEOAIC_OPTIONS['seoaic_competitors_update_interval']) != self::NEXT_UPDATE_DAYS
            ) {

                $url = empty($url_live) ? $url : $url_live;
                $seoaic_location = $this->seoaic_location();
                $location = empty($location) ? $seoaic_location : $location;

                $ready_to_update_competitors[] = [
                    'index' => $ID,
                    'domain' => $url,
                    'location' => $location,
                ];
            }
        }

        $SEOAIC_OPTIONS['ready_to_update_competitors'] = $ready_to_update_competitors;
        update_option('seoaic_options', $SEOAIC_OPTIONS);
        $this->nextUpdate();

        $item = !empty($_REQUEST['domain']) ? $_REQUEST['domain'] : '';
        $location = !empty($_REQUEST['location']) ? $_REQUEST['location'] : '';
        $index = !empty($_REQUEST['index']) ? $_REQUEST['index'] : 0;

        $this->fix_www_domain_url();

        if (empty($item)) {
            return;
        }

        $updated_competitors = array_filter($SEOAIC_OPTIONS['ready_to_update_competitors'], function ($item) use ($index) {
            return $item['index'] !== $index;
        });

        $SEOAIC_OPTIONS['ready_to_update_competitors'] = $updated_competitors;
        update_option('seoaic_options', $SEOAIC_OPTIONS);

        if (!empty($SEOAIC_OPTIONS['ready_to_update_competitors']) or !$update) {
            $this->Add_New_Competitor($item, $location, $index, true);
        }

    }

    public static function getLastUpdateTimestamp(): int
    {
        global $SEOAIC_OPTIONS;

        return !empty($SEOAIC_OPTIONS[self::LAST_UPDATE_FIELD]) ? intval($SEOAIC_OPTIONS[self::LAST_UPDATE_FIELD]) : 0;
    }

    public function updateCompetitorsDataManualAjax()
    {
        check_ajax_referer(SeoaicAjaxValidation::ACTION_STRING);

        global $SEOAIC_OPTIONS;

        $lastUpdate = self::getLastUpdateTimestamp();
        $nextTimestamp = $lastUpdate + self::NEXT_UPDATE_DAYS;
        $nextDate = gmdate('d/m/Y H:i e', $nextTimestamp);

        if (
            $lastUpdate
            && time() < $nextTimestamp
        ) {
            SEOAICAjaxResponse::alert(esc_html__("Next refresh available only on ", "seoaic") . $nextDate)->wpSend();
        }

        try {
            $competitors = $this->get_competitors();

            foreach ($competitors as $competitor) {
                $ID = $competitor->term_id;
                $url_live = $this->get_competitor_field_val($ID, 'url_live');
                $url = $this->get_competitor_field_val($ID, 'url');
                $url = empty($url_live) ? $url : $url_live;
                $location = $this->get_competitor_field_val($ID, 'location');
                $seoaic_location = $this->seoaic_location();
                $location = empty($location) ? $seoaic_location : $location;
                $language = seoaic_get_preferred_language($location);
                $slugLocation = '_' . $this->Slug($location);
                $my_site = $this->seoaic_company_website_url();

                $response = $this->request_data_competitors($language, $location, $url);

                $result = $response['result'];
                $rank_history = $response['rank_history'];
                $backlinks_result = $response['backlinks_result'];
                $next_update = $response['next_update'];

                $search_terms = [];
                if (
                    !empty($result['data'])
                    && count($result['data']) > 1
                ) {
                    foreach ($result['data'] as $terms) {
                        $search_terms[random_int(100000000, 999999999)] = $terms;
                    }
                }

                if ($url == $my_site) {
                    $SEOAIC_OPTIONS['on_page_seo_data']['historical_positions'] = $this->reorder_positions_stats($rank_history);
                }

                $this->competitors_fields($ID, $next_update, $url, $slugLocation, $location, $search_terms, $backlinks_result, $rank_history);
            }

            $SEOAIC_OPTIONS[self::LAST_UPDATE_FIELD] = time();
            update_option('seoaic_options', $SEOAIC_OPTIONS);

            SEOAICAjaxResponse::success('updated')->addFields([
                'content' => [
                    'content'   => '',
                    'notify'    => esc_html__('Competitors have been updated. The next refresh is available on ') . esc_html($nextDate),
                ],
            ])->wpSend();

        } catch (Exception $e) {
            SEOAICAjaxResponse::alert(esc_html__("Something went wrong", "seoaic"))->wpSend();
        }
    }

    public function search_volume_of_first_term($competitors_ids, $term_keyword)
    {
        $search_volume = 0;
        foreach ($competitors_ids as $id) {
            $search_terms = $this->get_search_terms($id);
            foreach ($search_terms as $term) {
                if ($term_keyword === $term['keyword']) {
                    $search_volume = isset($term['search_volume']) ? intval($term['search_volume']) : 0;
                    break;
                }
            }
        }
        return $search_volume == 0 ? '—' : $search_volume;
    }

    public function get_competitor_position_by_term($id, $term_keyword)
    {
        $search_terms = $this->get_search_terms($id);
        $position = 0;
        foreach ($search_terms as $term) {
            if ($term_keyword === $term['keyword']) {
                $position = !empty($term['position']) ? $term['position'] : 0;
                break;
            }
        }

        return $position == 0 ? '—' : $position;
    }

    public function get_competitor_location($id)
    {
        $location = $this->seoaic_location();
        $competitor_location = $this->get_competitor_field_val($id, 'location');
        return empty($competitor_location) ? $location : $competitor_location;
    }

    public function move_top_positions_to_start($terms, $sort_competitor)
    {
        $top_positions = [];
        $other_positions = [];

        foreach ($terms as $keyword => $data) {
            $position = isset($data['positions'][$sort_competitor]) ? $data['positions'][$sort_competitor] : PHP_INT_MAX;
            if ($position >= 1 && $position !== PHP_INT_MAX) {
                $top_positions[$keyword] = $data;
            } else {
                $other_positions[$keyword] = $data;
            }
        }

        return $top_positions + $other_positions;
    }

    public function compare_competitors()
    {
        check_ajax_referer(SeoaicAjaxValidation::ACTION_STRING);

        if (empty($_REQUEST['competitors'])) {
            wp_die();
        }

        $competitors = !is_array($_REQUEST['competitors']) ? explode(',', $_REQUEST['competitors']) : $_REQUEST['competitors'];
        $terms = [];
        $all_search_volumes = [];
        $competitors_heading_html = '';

        $sort_competitor = $competitors[0];

        foreach ($competitors as $competitor) {
            $search_keyword =!empty($_POST['search_keywords']) ? $_POST['search_keywords'] : '';
            $location = $this->get_competitor_location($competitor);
            $search_terms = $this->get_search_terms($competitor, $search_keyword);

            if (isset($search_terms) && is_array($search_terms)) {
                foreach ($search_terms as $term) {
                    if (isset($term['keyword'], $term['search_volume'], $term['position'])) {
                        $keyword = isset($term['keyword']) ? $term['keyword'] : '–';
                        $search_volume = isset($term['search_volume']) ? $term['search_volume'] : '–';
                        $difficulty = isset($term['difficulty']) ? $term['difficulty'] : '–';
                        $cpc = isset($term['cpc']) ? $term['cpc'] : 0;
                        //$etc = isset($term['etc']) ? $term['etc'] : 0;
                        $etc = isset($term['etc']) && isset($term['search_volume']) ? floatval($cpc) * intval($search_volume) : 0;
                        $position = isset($term['position']) ? $term['position'] : '–';
                        $page = isset($term['page']) ? $term['page'] : '–';
                        $title = isset($term['title']) ? $term['title'] : '–';
                        $meta_description = isset($term['meta_description']) ? $term['meta_description'] : '–';

                        if (!isset($terms[$keyword])) {
                            $terms[$keyword] = [
                                'search_volume' => $search_volume,
                                'difficulty' => $difficulty,
                                'cpc' => $cpc,
                                'etc' => $etc,
                                'positions' => [],
                                'pages' => [],
                                'titles' => [],
                                'meta_descriptions' => [],
                                'competitors' => []
                            ];
                            $all_search_volumes[] = $search_volume;
                        }

                        $terms[$keyword]['positions'][$competitor] = $position;
                        $terms[$keyword]['pages'][$competitor] = $page;
                        $terms[$keyword]['titles'][$competitor] = $title;
                        $terms[$keyword]['meta_descriptions'][$competitor] = $meta_description;
                        $terms[$keyword]['competitors'][] = $competitor;
                    }
                }

                $url_live = $this->get_competitor_field_val($competitor, 'url_live');

                if (empty($_POST['update_rows'])) {
                    $competitors_heading_html .= '<div class="col website" data-location="' . esc_attr($location) . '" data-website="' . esc_attr($url_live) . '" data-column="' . sanitize_title($url_live . ' ' . $location) . '" data-competitor-id="' . esc_attr($competitor) . '">
                        <div class="inner">' . esc_html($url_live) . '
                            <span class="sorting">
                                <span class="asc">▾</span>
                                <span class="desc">▾</span>
                            </span>
                        </div>
                    </div>';
                }
            }
        }

        $hide_branded = isset($_POST['hide_branded']);

        if($hide_branded) {

            $branded_keywords = seoaic_get_branded_keywords();

            $terms = array_filter($terms, function ($key) use ($hide_branded, $branded_keywords) {
                foreach ($branded_keywords as $variant) {
                    if (strpos($key, $variant) !== false) {
                        return !$hide_branded;
                    }
                }
                return $hide_branded;
            }, ARRAY_FILTER_USE_KEY);
        }

        uasort($terms, function ($a, $b) use ($sort_competitor) {
            $positionA = isset($a['positions'][$sort_competitor]) ? $a['positions'][$sort_competitor] : PHP_INT_MAX;
            $positionB = isset($b['positions'][$sort_competitor]) ? $b['positions'][$sort_competitor] : PHP_INT_MAX;
            return $positionA <=> $positionB;
        });

        if (!empty($_POST['sort_competitor']) && !empty($_POST['sort_direction'])) {

            $sort_competitor = $_REQUEST['sort_competitor'];
            $sort_direction = $_REQUEST['sort_direction'];

            uasort($terms, function ($a, $b) use ($sort_competitor, $sort_direction) {
                $positionA = isset($a['positions'][$sort_competitor]) ? $a['positions'][$sort_competitor] : PHP_INT_MAX;
                $positionB = isset($b['positions'][$sort_competitor]) ? $b['positions'][$sort_competitor] : PHP_INT_MAX;

                $comparison = $positionA <=> $positionB;

                return ($sort_direction == 'down') ? -$comparison : $comparison;
            });

            $terms = $this->move_top_positions_to_start($terms, $sort_competitor);
        }

        if (!empty($_POST['sort_search_volume'])) {
            uasort($terms, function ($a, $b) {
                if ($_POST['sort_search_volume'] == 'up') {
                    return $a['search_volume'] <=> $b['search_volume'];
                }
                return $b['search_volume'] <=> $a['search_volume'];
            });
        }

        if (!empty($_POST['sort_cpc_volume'])) {
            uasort($terms, function ($a, $b) {
                if ($_POST['sort_cpc_volume'] == 'up') {
                    return $a['cpc'] <=> $b['cpc'];
                }
                return $b['cpc'] <=> $a['cpc'];
            });
        }

        if (!empty($_POST['sort_etc_volume'])) {
            uasort($terms, function ($a, $b) {
                if ($_POST['sort_etc_volume'] == 'up') {
                    return $a['etc'] <=> $b['etc'];
                }
                return $b['etc'] <=> $a['etc'];
            });
        }

        if (!empty($_POST['sort_competition_volume'])) {
            uasort($terms, function ($a, $b) {
                if ($_POST['sort_competition_volume'] == 'up') {
                    return strcmp($a['difficulty'], $b['difficulty']);
                }
                return strcmp($b['difficulty'], $a['difficulty']);
            });
        }

        if (!empty($_POST['search_volume_min']) && !empty($_POST['search_volume_max'])) {
            $terms = array_filter($terms, function ($term) {
                return $term['search_volume'] >= $_POST['search_volume_min'] && $term['search_volume'] <= $_POST['search_volume_max'];
            });
        }

        if (!empty($_POST['sort_keyword'])) {
            uksort($terms, function ($a, $b) {
                if ($_POST['sort_keyword'] == 'up') {
                    return strcasecmp($a, $b);
                }
                return strcasecmp($b, $a);
            });
        }

        $term_html = '';

        $offset = 0;
        $per_page = 50;
        if (!empty($_POST['offset'])) {
            $offset = $_POST['offset'];
        }

        $terms = array_slice($terms, $offset, $per_page, true);

        foreach ($terms as $keyword => $data) {
            $competitors_html = '';
            $search_vol = $data['search_volume'];
            $difficulty = $data['difficulty'];
            $cpc = $data['cpc'];
            $etc = $data['etc'];

            foreach ($competitors as $competitor) {
                $location = $this->get_competitor_location($competitor);
                $url_live = $this->get_competitor_field_val($competitor, 'url_live');
                $position = isset($data['positions'][$competitor]) ? $data['positions'][$competitor] : '-';
                $page = isset($data['pages'][$competitor]) ? $data['pages'][$competitor] : '-';
                $title = isset($data['titles'][$competitor]) ? $data['titles'][$competitor] : '-';
                $meta_descriptions = isset($data['meta_descriptions'][$competitor]) ? $data['meta_descriptions'][$competitor] : '-';
                $page_link = !empty($page) && $page != '-' ? '<a data-title="' . esc_attr($title) . '" data-description="' . esc_attr($meta_descriptions) . '" href="' . esc_attr($page) . '" target="_blank">' . $position . '</a>' : '–';

                $competitors_html .=
                    '<div class="col website ' . sanitize_title($url_live . ' ' . $location) . '" data-competitor-id="' . esc_attr($competitor) . '">
                        <div class="inner">' . $page_link . '</div>
                    </div>';
            }

            $term_html .= '<div class="table-row">
                <div class="col checkbox">
                    <div class="inner">
                        <div class="position-relative">
                            <input type="checkbox" class="seoaic-checkbox select-compare" data-term="' . esc_attr($keyword) . '" data-term-id="' . array_search($keyword, array_keys($terms)) . '">
                        </div>
                    </div>
                </div>
                <div class="col keyword">
                    <div class="inner">' . esc_html($keyword) . '</div>
                </div>
                <div class="col serp">
                    <div class="inner">
                        <a href="#" data-keyword="' . esc_attr($keyword) . '" data-location="" data-action="seoaic_compare_competitors_term" data-modal="#add-competitors" class="modal-button">
                            <span>' . esc_html__('Analyse competition', 'seoaic') . '</span>
                        </a>
                    </div>
                </div>
                <div class="col competition-volume ' . esc_attr($difficulty ? $difficulty : '') . '">
                    <div class="inner">' . esc_html($difficulty ? $difficulty : '–') . '</div>
                </div>
                <div class="col cpc-volume">
                    <div class="inner">' . esc_html($cpc ? round($cpc, 3) : '–') . '</div>
                </div>
                <div class="col etc-volume">
                    <div class="inner">' . esc_html($etc > 0 ? round($etc) : '–') . '</div>
                </div>
                <div class="col search-volume">
                    <div class="inner">' . esc_html($search_vol) . '</div>
                </div>
                ' . $competitors_html . '
            </div>';
        }

        $filterable = '';
        if($all_search_volumes) {
            $filterable = min($all_search_volumes) !== max($all_search_volumes) ? 'seoai-filterable' : '';
        }

        $heading_html = '';
        if (empty($_POST['update_rows'])) {
            $heading_html = '<div class="table-row heading" data-offset="' . $per_page . '" data-per-page="' . $per_page . '">
                <div class="col checkbox">
                    <div class="inner">
                        <div class="position-relative">
                            <input type="checkbox" class="seoaic-checkbox select-all-compare">
                        </div>
                    </div>
                </div>
                <div class="col keyword" data-column="keyword">
                    <div class="inner">' . esc_html__('Keyword', 'seoaic') . '
                        <span class="sorting">
                            <span class="asc">▾</span>
                            <span class="desc">▾</span>
                        </span>
                    </div>
                    <div class="inner branded-button col">
                        <span class="hide-branded" data-hide="' . esc_html__('Hide branded', 'seoaic') . '" data-show="' . esc_html__('Show branded', 'seoaic') . '">' . esc_html__('Hide branded', 'seoaic') . '</span>
                    </div>
                    <div id="seoaic-search-compared-terms" class="no-drag">
                        <label for="seoaic-search-compared-terms-checkbox-activation" class=""></label>
                        <input id="seoaic-search-compared-terms-checkbox-activation" type="checkbox" class="d-none">
                        <input id="seoaic-search-compared-terms-input" placeholder="' . esc_html__('Search keywords', 'seoaic') . '" autocomplete="off" type="text">
                    </div>
                </div>
                <div class="col serp">
                    <div class="inner">
                        <button disabled id="seoaic_competitors_add_to_keywords" data-ideas-label="' . esc_html__("Generate ideas after adding a keywords", "seoaic") . '" data-modal="#add-keyword-modal" class="serp-selected modal-button">' . esc_html__('Add to keywords', 'seoaic') . '</button>
                        <button disabled id="seoaic_competitors_generate_ideas" data-modal="#generate-ideas-new-keywords" class="serp-selected modal-button">' . esc_html__('Generate ideas', 'seoaic') . '</button>
                    </div>
                </div>
                <div class="col competition-volume" data-sort="competition-volume" data-column="competition-volume">
                    <div class="inner">' . esc_html__('Competition', 'seoaic') . '
                        <span class="sorting">
                            <span class="asc">▾</span>
                            <span class="desc">▾</span>
                        </span>
                    </div>
                </div>
                <div class="col cpc-volume" data-sort="cpc-volume" data-column="cpc-volume">
                    <div class="inner">' . esc_html__('CPC', 'seoaic') . '
                        <span class="sorting">
                            <span class="asc">▾</span>
                            <span class="desc">▾</span>
                        </span>
                    </div>
                </div>
                <div class="col etc-volume" data-sort="etc-volume" data-column="etc-volume">
                    <div class="inner">' . esc_html__('ETC', 'seoaic') . '
                        <span class="sorting">
                            <span class="asc">▾</span>
                            <span class="desc">▾</span>
                        </span>
                    </div>
                </div>
                <div class="col search-volume ' . $filterable . ' seoai-filter-num float-values float-slider" data-sort="search-volume-compare" data-column="search-volume" data-min="' . min($all_search_volumes) . '" data-max="' . max($all_search_volumes) . '">
                    <div class="inner">' . esc_html__('Search volume', 'seoaic') . '
                        <span class="sorting">
                            <span class="asc">▾</span>
                            <span class="desc">▾</span>
                        </span>
                    </div>
                </div>
                ' . $competitors_heading_html . '
            </div>';
        }

        $html = sprintf(
            '<div class="table-competitors-compare dragscroll">
                %s
                %s
            </div>',
            $heading_html,
            $term_html
        );

        if (!empty($_POST['load_more']) || !empty($_POST['update_rows'])) {
            $html = $term_html;
        }

        $send = [
            'html' => $html,
            'search_vol_min' => 0,
            'search_vol_max' => 0,
            'columns_selects' => ''
        ];

        if($all_search_volumes) {
            $send['search_vol_min'] = min($all_search_volumes);
            $send['search_vol_max'] = max($all_search_volumes);
        }

        wp_send_json($send);
    }

    public function get_search_term_index($keyword, $location, $option_name)
    {
        global $SEOAIC_OPTIONS;
        $search_terms = !empty($SEOAIC_OPTIONS[$option_name]['google']) ? $SEOAIC_OPTIONS[$option_name]['google'] : [];
        $index = '';
        foreach ($search_terms as $key => $term) {
            if ($term['keyword'] === $keyword && $term['location'] === $location) {
                $index = $key;
            }
        }
        return $index;
    }

    public function COMPARE_my_article()
    {
        check_ajax_referer(SeoaicAjaxValidation::ACTION_STRING);

        global $SEOAIC;
        $location = $_REQUEST['location'];
        $keyword = $_REQUEST['keyword'];
        $option = 'terms_to_compare';
        $this->limit_terms_to_compere_store(10);
        $index = self::get_search_term_index($keyword, $location, $option);
        if (!$index) {
            $term = $this->Add_Terms([$keyword], 'google', '', $location, false, true, $option);
            $index = !empty($term[0]['index']) ? $term[0]['index'] : 0;
        }
        $my_article = $this->my_article_popup_top_table_analysis($index, true, $option);
        wp_send_json($my_article);
    }

    public function COMPARE_my_competitors()
    {
        check_ajax_referer(SeoaicAjaxValidation::ACTION_STRING);

        global $SEOAIC;
        $location = $_REQUEST['location'];
        $keyword = $_REQUEST['keyword'];
        $comp = $_REQUEST['competitors'];
        $option = 'terms_to_compare';
        $index = self::get_search_term_index($keyword, $location, $option);
        $competitors = $this->get_keyword_competitors(true, $index, $comp, $option);
        wp_send_json($this->competitors_table_html($competitors));
    }

    public function COMPARE_analysis()
    {
        check_ajax_referer(SeoaicAjaxValidation::ACTION_STRING);

        global $SEOAIC, $SEOAIC_OPTIONS;
        $location = $_REQUEST['location'];
        $keyword = $_REQUEST['keyword'];
        $comp = $_REQUEST['competitors'];
        $option = 'terms_to_compare';
        $index = self::get_search_term_index($keyword, $location, $option);
        $keyword = $SEOAIC_OPTIONS[$option]['google'][$index]['keyword'];
        $competitor_article = $this->competitor_article_popup_table_analysis($index, $keyword, $comp, $option, true);
        wp_send_json($competitor_article);
    }

    public function COMPARE_other_positions()
    {
        check_ajax_referer(SeoaicAjaxValidation::ACTION_STRING);

        global $SEOAIC;
        $location = $_REQUEST['location'];
        $keyword = $_REQUEST['keyword'];
        $option = 'terms_to_compare';
        $index = self::get_search_term_index($keyword, $location, $option);
        $top_five_competitors = $this->competitors_table_html($this->get_keyword_competitors(true, $index, [], $option), 5);
        wp_send_json($this->other_top_google_positions($top_five_competitors, ''));
    }

    public function get_top_google_analysis()
    {
        check_ajax_referer(SeoaicAjaxValidation::ACTION_STRING);

        global $SEOAIC;
        $location = $_REQUEST['location'];
        $keyword = $_REQUEST['keyword'];
        $option = 'terms_to_compare';
        $competitor = $_REQUEST['competitor'];
        $index = $this->get_search_term_index($keyword, $location, $option);
        $competitor_article = $this->competitor_article_popup_table_analysis($index, $keyword, [$competitor], $option);
        wp_send_json($competitor_article);
    }

    public function other_top_google_positions($competitors, $analysis)
    {

        $html = '<div class="other-top-5-positions">';

        $html .= '<h3>' . esc_html__("Top 5 in google", "seoaic") . '</h3>';

        $html .= '<div class="content-table">
                        <div class="body">' . $competitors . '</div>
                        <div class="competitor-article loading">
                        ' . $analysis . '
                            <a href="#" class="load-more-btn" >' . esc_html__('View more', 'seoaic') . '</a>
                        </div>
                      </div>';

        $html .= '</div>';

        return $html;
    }

    public function remove_all_competitor_terms($taxonomy)
    {
        global $wpdb;
        $sql = "DELETE FROM {$wpdb->terms} WHERE term_id IN (
            SELECT term_id FROM {$wpdb->term_taxonomy} WHERE taxonomy = '{$taxonomy}'
        )";
        $wpdb->query($sql);
        $deleted_term_count = $wpdb->rows_affected;

        $sql = "DELETE FROM {$wpdb->termmeta} WHERE term_id IN (
            SELECT term_id FROM {$wpdb->term_taxonomy} WHERE taxonomy = '{$taxonomy}'
        )";
        $wpdb->query($sql);
        $deleted_meta_count = $wpdb->rows_affected;

        return "Removed {$deleted_term_count} terms and {$deleted_meta_count} metadata entries from '{$taxonomy}'.";
    }

    public function combine_url_location($array)
    {
        $data = [];
        foreach ((array)$array as $i => $item) {
            $data[] = [
                'url_live' => $item['url_live'] ?? '',
                'location' => $item['location'] ?? '',
                'index' => $i,
            ];
        }

        return $data;
    }

    public function migrate_competitors_from_options()
    {
        check_ajax_referer(SeoaicAjaxValidation::ACTION_STRING);

        global $SEOAIC_OPTIONS;

        $competitors_options = !empty($SEOAIC_OPTIONS['competitors']) ? $SEOAIC_OPTIONS['competitors'] : [];
        if ($competitors_options && !isset($SEOAIC_OPTIONS['migrated_competitors'])) {
            $SEOAIC_OPTIONS['migrated_competitors'] = $this->combine_url_location($competitors_options);
        }

        $tax = self::COMPETITORS_AS_CATEGORIES_KEY;
        $count = 0;
        foreach ($competitors_options as $index => $competitor) {

            $ID = 0;
            $next_update = $competitor['next_update'];
            $url = $competitor['url_live'];
            $slugLocation = '_' . $this->Slug($competitor['location']);
            $location = $competitor['location'];
            $search_terms = $competitor['search_terms'];
            $backlinks_result = $competitor['backlinks'];
            $reordered_rank_history = $competitor['historical_rank'];

            unset($SEOAIC_OPTIONS['competitors'][$index]);
            update_option('seoaic_options', $SEOAIC_OPTIONS);

            $slug = $url . $slugLocation;
            $term_exist = get_term_by('slug', $slug, $tax);
            if (!$term_exist) {
                $this->competitors_fields($ID, $next_update, $url, $slugLocation, $location, $search_terms, $backlinks_result, [], $reordered_rank_history);
            }

            if ($count == 1) {
                break;
            }

            $count++;
        }

        wp_send_json([
            'url' => $url ?? '',
            'location' => $location ?? ''
        ]);

    }

    public function clean_all_competitors_data()
    {
        if (isset($_GET['remove-competitors']) && $_GET['remove-competitors']) {
            $this->remove_all_competitor_terms(self::COMPETITORS_AS_CATEGORIES_KEY);
        }
    }

    // VIEW COMPETITORS IN KEYWORDS START

    /**
     * Updates Keyword's data (meta fields)
     * @param array|int $keyword Keyword or ID
     * @param array $data meta fields to update. Assoc array in a "key => value" format
     * @return bool
     */
    private function updateKeywordData($keyword, $data = [])
    {
        if (empty($data)) {
            return false;
        }

        if (
            is_numeric($keyword)
            && (int)$keyword == $keyword
        ) {
            $id = $keyword;
        } else {
            $id = $keyword['id'];
        }

        $updateRes = wp_update_post([
            'ID' => $id,
            'meta_input' => $data,
        ]);

        if (is_wp_error($updateRes)) {
            return false;
        }

        WPTransients::deleteCachedValue(self::KEYWORDS_CACHE_KEY);

        return true;
    }

    public function get_keyword_competitors_ajax()
    {
        check_ajax_referer(SeoaicAjaxValidation::ACTION_STRING);

        $this->get_keyword_competitors();
    }

    /**
     * Get Competitors
     * params
     */
    public function get_keyword_competitors($return = false, $keyword = '', $competitors = [], $option_name = 'search_terms', $get_data = false)
    {
        global $SEOAIC_OPTIONS, $SEOAIC;

        $search_engine = isset($_GET['search_engine']) ? $_GET['search_engine'] : 'google';

        if ($keyword) {
            $_POST['keyword'] = $keyword;
        }

        $current = !empty($SEOAIC_OPTIONS[$option_name][$search_engine][intval($_POST['keyword'])])
            ? $SEOAIC_OPTIONS[$option_name][$search_engine][intval($_POST['keyword'])]
            : [];

        $interval = DAY_IN_SECONDS * 7;
        //$interval = DAY_IN_SECONDS * 30;

        $data_id = 0;
        $serp = 'serp';
        $serp_data = '';
        $next_update = isset($current[$serp]['last_update']) && is_numeric($current[$serp]['last_update']) && $current[$serp]['last_update'] > 0 ? $current[$serp]['last_update'] + ($interval) : false;
        if (isset($_POST['data_id'])) {
            $data_id = intval($_POST['data_id']);
            $serp = 'serp_data';
            $current = $SEOAIC->keywords->getKeywordByID($data_id);
            $serp_data = unserialize($SEOAIC->keywords->getKeywordByID($data_id)[$serp]);
            $next_update = isset($serp_data['last_update']) && is_numeric($serp_data['last_update']) && $serp_data['last_update'] > 0 ? $serp_data['last_update'] + ($interval) : false;
        }

        if (
            array_key_exists($serp, $current)
            && array_key_exists('article_analysis', $serp_data ? $serp_data : $current)
            && time() <= $next_update
        ) {

            if ($return) {

                if ($competitors) {
                    return $this->get_spesific_competitors($competitors, $current[$serp]['data']);
                } else {
                    return $current[$serp]['data'];
                }

            }

            if ($data_id) {

                if($get_data) {
                    return $serp_data['data'];
                }

                wp_send_json($this->competitors_table_html($serp_data['data']));
            }

            wp_send_json($this->competitors_table_html($current['serp']['data']));

        } else {
            $index = $this->Request_Competitors($current, $search_engine, $option_name, $data_id);

            if ($index > -1) {
                if ($return) {
                    if ($competitors) {
                        $all_domains = array_column($SEOAIC_OPTIONS[$option_name][$search_engine][$index][$serp]['data'], 'domain');

                        foreach ($competitors as $competitor) {
                            if (!in_array($competitor, $all_domains)) {
                                $SEOAIC_OPTIONS[$option_name][$search_engine][$index][$serp]['data'][] = [
                                    'domain' => $competitor,
                                ];
                                update_option('seoaic_options', $SEOAIC_OPTIONS);
                            }
                        }

                        return $this->get_spesific_competitors($competitors, $SEOAIC_OPTIONS[$option_name][$search_engine][$index][$serp]['data']);
                    } else {
                        return $SEOAIC_OPTIONS[$option_name][$search_engine][$index]['serp']['data'];
                    }
                }
                if ($data_id) {
                    $updated = unserialize($SEOAIC->keywords->getKeywordByID($index)[$serp]);

                    if($get_data) {
                        return $updated['data'];
                    }

                    wp_send_json($this->competitors_table_html($updated['data']));
                }

                wp_send_json($this->competitors_table_html($SEOAIC_OPTIONS[$option_name][$search_engine][$index]['serp']['data']));
            }
        }

        wp_send_json([
            'status' => true
        ]);
    }

    public function added_keyword_competitors()
    {
        check_ajax_referer(SeoaicAjaxValidation::ACTION_STRING);

        global $SEOAIC_OPTIONS, $SEOAIC;

        $search_engine = isset($_GET['search_engine']) ? $_GET['search_engine'] : 'google';
        $competitors = isset($_REQUEST['competitors']) ? $_REQUEST['competitors'] : [];
        $keyword_slug = isset($_REQUEST['keyword_slug']) ? $_REQUEST['keyword_slug'] : '';
        $data_id = isset($_REQUEST['data_id']) ? $_REQUEST['data_id'] : 0;

        if ($data_id) {
            $term = $SEOAIC->keywords->getKeywordByID($data_id);
            $serp_data = unserialize($term['serp_data']);

            $serp_data['added_competitors'] = $competitors;
            $this->updateKeywordData($data_id, ['serp_data' => $serp_data]);

        }

//        else {
//            foreach ($SEOAIC_OPTIONS['search_terms'][$search_engine] as &$term) {
//
//                if ($term['slug'] == $keyword_slug) {
//                    $term['added_competitors'] = $competitors;
//                }
//            }
//
//            update_option('seoaic_options', $SEOAIC_OPTIONS);
//        }

        $list = '';
        if (isset($competitors[0])) {
            $list .= '<ul>';
            foreach ($competitors as $single) {
                if ($single)
                    $list .= '<li><a href="#" class="modal-button" data-modal="#competitor-compare" data-position="' . esc_attr($single['position']) . '"><span>' . esc_html(str_replace("www.", "", $single['domain'])) . '</span></a><span class="pos"><i class="icon-step-posotion"></i>' . esc_html($single['position']) . '</span></li>';
            }
            $list .= '</ul>';
        }

        wp_send_json([
            'status' => 'success',
            'competitors' => $list,
        ]);

        die();
    }

    public function my_article_popup_top_table_analysis_ajax()
    {
        check_ajax_referer(SeoaicAjaxValidation::ACTION_STRING);

        $this->my_article_popup_top_table_analysis();
    }

    public function my_article_popup_top_table_analysis($i = '', $return = false, $option_name = 'search_terms')
    {
        global $SEOAIC_OPTIONS, $SEOAIC;

        $search_engine = 'google';
        $index = isset($_REQUEST['index']) ? intval($_REQUEST['index']) : 0;
        if ($i) {
            $index = $i;
        }
        $term = !empty($SEOAIC_OPTIONS[$option_name][$search_engine][$index]) ? $SEOAIC_OPTIONS[$option_name][$search_engine][$index] : [];
        $page = !empty($term['page']) ? $term['page'] : '';
        $position = !empty($term['position']) ? $term['position'] : '';
        if (isset($_REQUEST['keyword_serp'])) {
            $term = $SEOAIC->keywords->getKeywordByID($index);
            $serp_data = unserialize($term['serp_data']);
            $page = !empty($term['rank_data'][0]['page']) ? $term['rank_data'][0]['page'] : '';
            $position = !empty($term['rank_data'][0]['position']) ? $term['rank_data'][0]['position'] : '';
            $term = $serp_data;
        }

        $page = !empty($page) ? $page : '—';
        $position = !empty($position) ? $position : '—';
        $description = !empty($term['description']) ? $term['description'] : '—';
        $title = !empty($term['title']) ? $term['title'] : '';
        $paragraphs = !empty($page) ? (!empty($term['article_analysis']['p']) ? $term['article_analysis']['p'] : '—') : '—';
        $rank_count = !empty($term['article_analysis']['rank_count']) ? $term['article_analysis']['rank_count'] : '—';
        $backlinks_short = !empty($term['article_analysis']['backlinks_short']) ? $term['article_analysis']['backlinks_short'] : '—';
        $backlinks_count = !empty($term['article_analysis']['backlinks_count']) ? $term['article_analysis']['backlinks_count'] : '—';
        $h1 = !empty($page) ? (!empty($term['article_analysis']['h1']) ? $term['article_analysis']['h1'] : '—') : '—';
        $h1_count = !empty($page) ? (!empty(is_array($h1)) ? count($h1) : '—') : '—';
        $h2 = !empty($page) ? (!empty($term['article_analysis']['h2']) ? $term['article_analysis']['h2'] : '—') : '—';
        $h2_count = !empty($page) ? (!empty(is_array($h2)) ? count($h2) : '—') : '—';
        $sentences = !empty($page) ? (!empty($term['article_analysis']['sentences']) ? $term['article_analysis']['sentences'] : '—') : '—';
        $keyword_density = !empty($page) ? (!empty($term['article_analysis']['keyword_density']) ? $term['article_analysis']['keyword_density'] : '—') : '—';
        $words = !empty($page) ? (!empty($term['article_analysis']['words']) ? $term['article_analysis']['words'] : '—') : '—';
        $automated_readability_index = !empty($page) ? (!empty($term['article_analysis']['automated_readability_index']) ? $term['article_analysis']['automated_readability_index'] : '—') : '—';

        $toggle = $h1 == '—' && $h2 == '—' && $description == '—' ? '' : '<div class="toggle"></div>';

        $h1_list = '';
        if ($h1 && is_array($h1)) {
            $h1_list .= '<ul>';
            foreach ($h1 as $li) {
                $h1_list .= '<li>' . $li . '</li>';
            }
            $h1_list .= '</ul>';
        }

        $h2_list = '';
        if ($h2 && is_array($h2)) {
            $h2_list .= '<ul>';
            foreach ($h2 as $li) {
                $h2_list .= '<li>' . $li . '</li>';
            }
            $h1_list .= '</ul>';
        }

        $html = '<div class="flex-table">
                    <div class="row-line heading">
                        <div class="my-website-info"><span class="label-accent">' . esc_html__('My article', 'seoaic') . '</span></div>
                        <div class="google-position">
                            <span class="label">' . esc_html__('Google Position', 'seoaic') . '</span>
                        </div>
                        <div class="h1-titles">
                            <span class="label">' . esc_html__('H1 Titles', 'seoaic') . '</span>
                        </div>
                        <div class="h2-titles">
                            <span class="label">' . esc_html__('H2 Titles', 'seoaic') . '</span>
                        </div>
                        <div class="sentences">
                            <span class="label">' . esc_html__('Sentences', 'seoaic') . '</span>
                        </div>
                        <div class="keyword-density">
                            <span class="label">' . esc_html__('Keyword density', 'seoaic') . '</span>
                        </div>
                        <div class="words">
                            <span class="label">' . esc_html__('Words', 'seoaic') . '</span>
                        </div>
                        <div class="paragraphs">
                            <span class="label">' . esc_html__('DR & Backlinks', 'seoaic') . '</span>
                        </div>
                        <div class="readability">
                            <span class="label">' . esc_html__('Readability', 'seoaic') . '</span>
                        </div>

                        <div class="delete"></div>
                    </div>
                    <div class="row-line highlight my-article">
                        <div class="my-website-info">
                            <div class="inner">
                                <span class="page-url limit-text-lines lines-1">' . $page . '</span>
                                <span class="page-title limit-text-lines lines-1">' . $title . '</span>
                                ' . $toggle . '
                            </div>
                        </div>
                        <div class="google-position">
                            ' . $position . '
                        </div>
                        <div class="h1-titles">
                            ' . $h1_count . '
                        </div>
                        <div class="h2-titles">
                            ' . $h2_count . '
                        </div>
                        <div class="sentences">
                            ' . $sentences . '
                        </div>
                        <div class="keyword-density">
                            ' . $keyword_density . '
                        </div>
                        <div class="words">
                            ' . $words . '
                        </div>
                        <div class="paragraphs">
                            ' . $backlinks_short . '
                        </div>
                        <div class="readability">
                            ' . $automated_readability_index . '
                        </div>
                        <div class="delete column-key"></div>

                    </div>
                    <div class="my-article-info">
                        <div class="neta">
                            <div class="inner">
                                <div class="title limit-text-lines lines-2">' . esc_html__('Page Description', 'seoaic') . '</div>
                                <div class="description limit-text-lines lines-5">' . $description . '</div>
                            </div>
                        </div>
                        <div class="h1-tags">
                            <div class="inner">
                                <div class="title">H1</div>
                               ' . $h1_list . '
                            </div>
                        </div>
                        <div class="h2-tags">
                            <div class="inner">
                                <div class="title">H2</div>
                                ' . $h2_list . '
                            </div>
                            <a href="#" class="my-content-toggle-modal seoaic-view-more">' . esc_html__('View more', 'seoaic') . '</a>
                        </div>
                    </div>
                </div>';

        if (isset($_REQUEST['index']) && !$return) {
            wp_send_json($html);
        }
        return $html;
    }

    public function competitor_article_popup_table_analysis_ajax()
    {
        check_ajax_referer(SeoaicAjaxValidation::ACTION_STRING);

        $this->competitor_article_popup_table_analysis();
    }

    public function competitor_article_popup_table_analysis($term_index = false, $keyword = '', $competitors = [], $option_name = 'search_terms', $array_map = false)
    {
        global $SEOAIC_OPTIONS, $SEOAIC;

        $search_engine = 'google';

        $index = isset($_REQUEST['index']) ? intval($_REQUEST['index']) : 0;
        $term_keyword = !isset($_REQUEST['term_keyword']) ? '' : $_REQUEST['term_keyword'];

        if ($term_index) {
            $index = $term_index;
            $term_keyword = $keyword;
        }

        $term_data = !empty($SEOAIC_OPTIONS[$option_name][$search_engine][$index]) ? $SEOAIC_OPTIONS[$option_name][$search_engine][$index] : [];
        $term = !empty($term_data['serp']['data']) ? $term_data['serp']['data'] : [];
        $location = $SEOAIC_OPTIONS[$option_name][$search_engine][$index]['location'] ?? '';
        $updated_competitors = [];
        $i = 0;
        $html = '';
        $break_on = 3;
        $serp_data = [];
        if ($competitors) {
            $term = $this->get_spesific_competitors($competitors, $term);
            $break_on = count($term);
            $location = $_REQUEST['location'];
            $term_keyword = $_REQUEST['keyword'];
        }
        if (isset($_REQUEST['keyword_serp'])) {
            $term_name = $SEOAIC->keywords->getKeywordByID($index);
            $location = $term_name['location'];
            $term_keyword = $term_name['name'];
            $serp_data = unserialize($term_name['serp_data']);
            $term = $serp_data['data'];
            $my_article_analysis = $serp_data['article_analysis'];
        }

        foreach ($term as $key => $competitor) {

            if (!empty($competitor) && empty(array_column($term, 'article_analysis')) || isset($_REQUEST['load_more']) && !array_key_exists('article_analysis', $competitor)) {

                $url = !empty($competitor['url']) ? $competitor['url'] : '';
                $article_analysis = $this->parse_content_analysis($url, $term_keyword, $location);

                if ($serp_data) {
                    $serp_data['data'][$key]['article_analysis'] = $article_analysis;
                    $this->updateKeywordData($index, ['serp_data' => $serp_data]);
                } else {
                    $SEOAIC_OPTIONS[$option_name][$search_engine][$index]['serp']['data'][$key]['article_analysis'] = $article_analysis;
                    update_option('seoaic_options', $SEOAIC_OPTIONS);
                }

                $html .= $this->analysis_table_HTML($article_analysis, $key);
                $i++;
            }

            if ($i == $break_on) {
                break;
            }
        }

        if (isset($_REQUEST['load_more'])) {
            $term = $updated_competitors;
        }

//        if($array_map) {
//            $competitors_has_analysis = array_map(function($item) {
//                return $item['article_analysis'];
//            }, $term);
//        } else {
//            $competitors_has_analysis = array_column($term, 'article_analysis');
//        }

        $competitors_has_analysis = array_column($term, 'article_analysis');

        foreach ($competitors_has_analysis as $key => $competitor) {
            $html .= $this->analysis_table_HTML($competitor, $key);
        }

        if (isset($_REQUEST['index']) && !$term_index) {
            wp_send_json($html);
        }
        return $html;

    }

    public function parse_content_analysis($url, $keyword, $location)
    {

        if (empty($url)) {
            return [];
        }

        $parse_url = wp_parse_url($url);
        $target = $parse_url['host'];

        $parsing = $this->get_content_analysis($url, $target, $keyword, $location);

        if (!$parsing) {
            return
                [
                    'p' => 0,
                    'rank_count' => 0,
                    'backlinks_count' => 0,
                    'backlinks_short' => '',
                    'h1' => 0,
                    'h2' => 0,
                    'sentences' => 0,
                    'keyword_density' => 0,
                    'words' => 0,
                    'automated_readability_index' => 0,
                    'url' => $url
                ];
        }

        $rank_count = !empty($parsing["data"]["domain_backlinks"]["rank"]) ? $parsing["data"]["domain_backlinks"]["rank"] : 0;
        $backlinks_count = !empty($parsing["data"]["domain_backlinks"]["backlinks"]) ? $parsing["data"]["domain_backlinks"]["backlinks"] : 0;
        $rank_help = $rank_count ? '<span class="help">' . esc_html__('Domain Rank: ', 'seoaic') . $rank_count . '</span> ' : '';
        $backlinks_help = $backlinks_count ? '<span class="help">' .  esc_html__('Backlinks: ', 'seoaic') . $backlinks_count . '</span> ' : '';
        $help = $rank_help || $backlinks_help ? '<div class="help-wrap">' . $rank_help . $backlinks_help . '</div> ' : '';
        $backlinks_short = $rank_count ? $rank_count . ' <small>(' . $this->short_number($backlinks_count) . ')</small>' . $help : '';

        $h1_tags = !empty($parsing['data']['on_page_seo']['meta']['htags']['h1']) ? $parsing['data']['on_page_seo']['meta']['htags']['h1'] : [];
        $h2_tags = !empty($parsing['data']['on_page_seo']['meta']['htags']['h2']) ? $parsing['data']['on_page_seo']['meta']['htags']['h2'] : [];

        $page_score = !empty($parsing['data']['on_page_seo']['onpage_score']) ? $parsing['data']['on_page_seo']['onpage_score'] : 0;

        $words = !empty($parsing["data"]['content_analysis']['words']) ? $parsing["data"]['content_analysis']['words'] : 0;
        $sentences = !empty($parsing["data"]['content_analysis']['sentences']) ? $parsing["data"]['content_analysis']['sentences'] : 0;
        $automated_readability_index = !empty($parsing["data"]['content_analysis']['automated_readability_index']) ? $parsing["data"]['content_analysis']['automated_readability_index'] : 0;
        $plain_text_cleaned = !empty($parsing["data"]['parsed_text']) ? $parsing["data"]['parsed_text'] : 0;

        $keyword_density = $keyword && $plain_text_cleaned ? substr_count(strtolower($plain_text_cleaned), strtolower($keyword)) : 0;
        $keyword_density_count = number_format($keyword_density, 0, '');
        $keyword_density_percentage = $keyword_density && $words ? $keyword_density / $words * 100 : 0;
        $keyword_density = $keyword_density_count ? $keyword_density_count . ' <small>(' . number_format($keyword_density_percentage, 2) . '%)</small>' : 0;

        return
            [
                'p' => $page_score,
                'rank_count' => $rank_count,
                'backlinks_count' => $backlinks_count,
                'backlinks_short' => $backlinks_short,
                'h1' => $h1_tags,
                'h2' => $h2_tags,
                'sentences' => $sentences,
                'keyword_density' => $keyword_density,
                'keyword_density_percentage' => $keyword_density_percentage,
                'words' => $words,
                'automated_readability_index' => round($automated_readability_index),
                'url' => $url
            ];
    }

    public function short_number($number)
    {
        $base = log($number, 1000);
        $suffixes = array('', 'k', 'm', 'b', 't', 'kv', 'kk', 'mk', 'mm', 'bm', 'tm', 'kvm', 'kkm', 'mkm');

        return round(pow(1000, $base - floor($base)), 1) . $suffixes[floor($base)];
    }

    public function get_content_analysis($url, $target, $keyword, $location)
    {

        global $SEOAIC_OPTIONS;
        $data = [
            'email' => $SEOAIC_OPTIONS['seoaic_api_email'],
            'token' => $SEOAIC_OPTIONS['seoaic_api_token'],
            'url' => $url,
            'target' => $target,
            'keyword' => $keyword,
            'location' => $location,
            'language' => 'English',
        ];

        return $this->seoaic->curl->init('/api/ai/keyword-stats', $data, true, true, true);
    }

    public function get_data($data, $empty_response = 0)
    {
        $return = $empty_response;
        if (isset($data)) {
            $return = $data;
        }
        return $return;
    }

    public function table_row_HTML($analysis_url, $h1_count, $h1_array, $h2_count, $h2_array, $sentences, $keyword_density, $words, $paragraphs, $automated_readability_index, $keyword_density_percentage, $rank_count, $backlinks_short, $backlinks_count, $index)
    {

        $h1_list = '';
        if ($h1_array && is_array($h1_array)) {
            $h1_list .= '<ul>';
            foreach ($h1_array as $li) {
                $h1_list .= '<li>' . esc_html($li) . '</li>';
            }
            $h1_list .= '</ul>';
        } else {
            $h1_list .= '—';
        }
        $h1_list_safe = $h1_list;

        $h2_list = '';
        if ($h2_array && is_array($h2_array)) {
            $h2_list .= '<ul>';
            foreach ($h2_array as $li) {
                $h2_list .= '<li>' . esc_html($li) . '</li>';
            }
            $h2_list .= '</ul>';
        } else {
            $h2_list .= '—';
        }
        $h2_list_safe = $h2_list;

        return '<div class="row-line article-analysis" data-url="' . esc_url($analysis_url) . '" data-index="' . esc_attr($index) . '">
                    <div class="h1-titles" data-val="' . esc_attr($h1_count) . '">
                        ' . $h1_count . '
                    </div>
                    <div class="h2-titles" data-val="' . esc_attr($h2_count) . '">
                        ' . $h2_count . '
                    </div>
                    <div class="sentences" data-val="' . esc_attr($sentences) . '">
                        ' . $sentences . '
                    </div>
                    <div class="keyword-density" data-val="' . esc_attr($keyword_density) . '" data-val-percentage="' . esc_attr($keyword_density_percentage) . '">
                        ' . $keyword_density . '
                    </div>
                    <div class="words" data-val="' . esc_attr($words) . '">
                        ' . $words . '
                    </div>
                    <div class="paragraphs" data-val="' . esc_attr($rank_count) . '" data-val-backlinks="' . esc_attr($backlinks_count) . '">
                        ' . $backlinks_short . '
                    </div>
                    <div class="readability" data-val="' . esc_attr($automated_readability_index) . '">
                        ' . $automated_readability_index . '
                    </div>
                </div>
                <div class="article-info">
                    <div class="h1-tags">
                        <div class="inner">
                            <div class="title">H1</div>
                           ' . $h1_list_safe . '
                        </div>
                    </div>
                    <div class="h2-tags">
                        <div class="inner">
                            <div class="title">H2</div>
                            ' . $h2_list_safe . '
                        </div>
                    </div>
                </div>
                ';
    }

    public function analysis_table_HTML($article_analysis, $key)
    {
        $h1 = !empty($article_analysis['h1']) ? $article_analysis['h1'] : '—';
        $h2 = !empty($article_analysis['h2']) ? $article_analysis['h2'] : '—';
        $h1_count = !empty(is_array($h1)) ? count($h1) : '—';
        $h2_count = !empty(is_array($h2)) ? count($h2) : '—';
        $sentences = !empty($article_analysis['sentences']) ? $article_analysis['sentences'] : '—';
        $keyword_density = !empty($article_analysis['keyword_density']) ? $article_analysis['keyword_density'] : '—';
        $keyword_density_percentage = !empty($article_analysis['keyword_density_percentage']) ? $article_analysis['keyword_density_percentage'] : '—';
        $words = !empty($article_analysis['words']) ? $article_analysis['words'] : '—';
        $paragraphs = !empty($article_analysis['p']) ? $article_analysis['p'] : '—';
        $rank_count = !empty($article_analysis['rank_count']) ? $article_analysis['rank_count'] : '—';
        $backlinks_short = !empty($article_analysis['backlinks_short']) ? $article_analysis['backlinks_short'] : '—';
        $backlinks_count = !empty($article_analysis['backlinks_count']) ? $article_analysis['backlinks_count'] : '—';
        $automated_readability_index = !empty($article_analysis['automated_readability_index']) ? $article_analysis['automated_readability_index'] : '—';
        $analysis_url = !empty($article_analysis['url']) ? $article_analysis['url'] : '—';

        return $this->table_row_HTML($analysis_url, $h1_count, $h1, $h2_count, $h2, $sentences, $keyword_density, $words, $paragraphs, $automated_readability_index, $keyword_density_percentage, $rank_count, $backlinks_short, $backlinks_count, $key);
    }

    public function get_spesific_competitors($find_competitors, $all_competitors)
    {

        $result = [];

        $normalized_find_competitors = array_map(function($domain) {
            return preg_replace('/^www\./', '', $domain);
        }, $find_competitors);
        foreach ($find_competitors as $index => $find_domain) {
            $found = false;

            foreach ($all_competitors as $key => $competitor) {
                $normalized_domain = preg_replace('/^www\./', '', $competitor['domain']);

                if ($normalized_find_competitors[$index] === $normalized_domain) {
                    $result[$key] = $competitor;
                    $found = true;
                    break;
                }
            }

            if (!$found) {
                $result[count($all_competitors)] = [
                    'domain' => $find_domain,
                    'article_analysis' => [],
                ];
            }
        }

        ksort($result);

        return $result;
    }

    public function competitors_table_html($competitors, $limit = -1)
    {
        global $SEOAIC;
        $competitors_html = [];
        $current_domain = $SEOAIC->competitors->seoaic_company_website_url();

        $count = 1;
        foreach ($competitors as $i => $competitor) {

            $domain = !empty($competitor['domain']) ? $competitor['domain'] : '';
            $current_domain_class = ($current_domain === $domain) ? ' highlighted' : '';
            $position = !empty($competitor['avg_position']) ? $competitor['avg_position'] : '-';
            $url = !empty($competitor['url']) ? esc_url($competitor['url']) : '-';
            $check_box = !$current_domain_class ? '<input class="seoaic-competitor-check" name="seoaic-check-competitor" type="checkbox" data-position="' . esc_attr($position) . '" value="' . esc_attr($domain) . '" data-url="' . esc_attr($url) . '">' : '';
            $title = !empty($competitor['title']) ? esc_html($competitor['title']) : '-';
            $description = !empty($competitor['description']) ? esc_html($competitor['description']) : '-';

            $competitors_html[] = <<<HTML
            <div class="table-row{$current_domain_class}" data-index="{$i}">
                <div class="visibility selected">
                    <div class="check">{$check_box}</div>
                </div>
                <div class="domain">
                    <div class="inner">
                        <span class="limit-text-lines lines-1">{$domain}</span>
                        <a target="_blank" href="{$url}">{$title}</a>
                    </div>
                </div>
                <div class="avg_position">{$position}</div>
            </div>
            <div class="article-info">
                <div class="neta">
                    <div class="inner">
                        <div class="title limit-text-lines lines-2"><?php esc_html_e('Page Description', 'seoaic');?></div>
                        <div class="description limit-text-lines lines-5"><span>{$description}</span><a style="display: none" href="#" data-modal="#seoaic-content-improvement-analyze" class="d-block modal-button">Comparative analysis</a></div>
                    </div>
                </div>
            </div>
            HTML;

            if (
                $limit > 0
                && $count == $limit
            ) {
                break;
            }

            $count++;
        }

        return implode('', $competitors_html);
    }

    /**
     * Request Competitors
     * params
     * array $keyword
     * string $search_engine
     */
    private function Request_Competitors($keyword, $search_engine = 'google', $option_name = 'search_terms', $data_id = 0)
    {
        global $SEOAIC_OPTIONS;

        $keyword_name = !empty($keyword['keyword']) ? $keyword['keyword'] : $keyword['name'];
        $location = !empty($SEOAIC_OPTIONS['seoaic_location']) ? $SEOAIC_OPTIONS['seoaic_location'] : 'United States';
        $data = [
            'email' => $SEOAIC_OPTIONS['seoaic_api_email'],
            'token' => $SEOAIC_OPTIONS['seoaic_api_token'],
            'language' => !empty($SEOAIC_OPTIONS['seoaic_language']) ? $SEOAIC_OPTIONS['seoaic_language'] : 'English',
            'location' => !empty($SEOAIC_OPTIONS['seoaic_location']) ? $SEOAIC_OPTIONS['seoaic_location'] : 'United States',
            'keywords' => [$keyword_name],
        ];

        $result = $this->seoaic->curl->init('api/ai/keywords-serp-competitors', $data, true, true, true);

        $index = -1;

        if (!empty($result['status']) && $result['status'] === 'success') {

            if ($data_id) {
                $page = !isset($keyword['rank_data'][0]['page']) ? '' : $keyword['rank_data'][0]['page'];
                $this->updateKeywordData($data_id, ['serp_data' => [
                    'last_update' => time(),
                    'article_analysis' => !empty($page) ? $this->parse_content_analysis($page, $keyword_name, $location) : [],
                    'data' => $result['data'][$keyword['name']]
                ]]);

                return $data_id;
            }

            foreach ($SEOAIC_OPTIONS[$option_name][$search_engine] as $i => $keyword) {
                if (in_array($keyword['keyword'], array_keys($result['data']))) {
                    $index = $i;
                    $SEOAIC_OPTIONS[$option_name][$search_engine][$i]['serp'] = [
                        'last_update' => time(),
                        'data' => $result['data'][$keyword['keyword']]
                    ];
                }
            }
            update_option('seoaic_options', $SEOAIC_OPTIONS);
        }

        return $index;
    }

    public function limit_terms_to_compere_store($limit)
    {
        global $SEOAIC_OPTIONS;
        $terms_to_compere = !isset($SEOAIC_OPTIONS['terms_to_compare']) ? [] : $SEOAIC_OPTIONS['terms_to_compare'];
        $terms_to_compere_google = !isset($SEOAIC_OPTIONS['terms_to_compare']['google']) ? [] : $SEOAIC_OPTIONS['terms_to_compare']['google'];
        if (
            count($terms_to_compere) > $limit
            ||
            count($terms_to_compere_google) > $limit) {
            $last_element = array_pop($terms_to_compere_google);
            array_unshift($terms_to_compere_google, $last_element);
            $SEOAIC_OPTIONS['terms_to_compare']['google'] = array_slice($terms_to_compere_google, 0, 10);
            update_option('seoaic_options', $SEOAIC_OPTIONS);
        }
    }

    /**
     * Add Search Terms
     */
    public function Add_Terms($terms, $search_engine, $parent, $location, $update = false, $return = false, $option_name = 'search_terms', $language = 'English')
    {
        global $SEOAIC_OPTIONS, $SEOAIC;

        $next_update = (30 * DAY_IN_SECONDS) + time();

        if (empty($location)) {
            $location = $SEOAIC->competitors->seoaic_location();
        }

        if (!empty($_REQUEST['language'])) {
            $language = $_REQUEST['language'];
        }

        $limit = 100;

        $company_website = !empty($SEOAIC_OPTIONS['seoaic_company_website']) ? $SEOAIC_OPTIONS['seoaic_company_website'] : get_bloginfo('url');
        $company_website = wp_parse_url($company_website)['host'];

        $here = '';
        $all_terms = !empty($SEOAIC_OPTIONS[$option_name][$search_engine]) ? $SEOAIC_OPTIONS[$option_name][$search_engine] : [];

        $get_all_terms = array_column($all_terms, 'slug');

        $added_terms = [];

        foreach ($terms as $term_index => $term) {

            $data = [
                'email' => $SEOAIC_OPTIONS['seoaic_api_email'],
                'token' => $SEOAIC_OPTIONS['seoaic_api_token'],
                'language' => $language,
                'location' => $location,
                'target' => $company_website,
                'limit' => $limit,
                'add_terms' => $term,
                'keywords' => [$term],
            ];

            if (!$update) {
                if (in_array($this->Slug($term . '_' . $location), $get_all_terms)) {
                    $here = '<li>Term "' . $term . '" for ' . $location . ' - <span class="red">already exists</span></li>';
                    break;
                }
            }

            $result = $this->seoaic->curl->init('api/ai/rank-search-terms', $data, true, true, true);

            $historical_rank = $this->seoaic->curl->init('api/ai/keywords-ranks', $data, true, true, true);

            $keyword = isset($result['data'][0]['keyword']) ? str_replace('\\', '', strtolower($result['data'][0]['keyword'])) : str_replace('\\', '', strtolower($term));
            $position = isset($result['data'][0]['position']) ? (int)$result['data'][0]['position'] : '';
            $page = !empty($result['data'][0]['page']) ? $result['data'][0]['page'] : '';
            $description = !empty($result['data'][0]['description']) ? $result['data'][0]['description'] : '';
            $title = !empty($result['data'][0]['title']) ? $result['data'][0]['title'] : '';
            $article_analysis = !empty($page) ? $this->parse_content_analysis($page, $term, $location) : [];

            $rank_history = [];
            foreach ((array)$historical_rank['data'] as $rank) {
                $rank_history = array_merge($rank_history, $rank['values']);
            }

            foreach ($rank_history as $i_rank => $rank) {
                $str_date = $rank[0];
                $rank_history[$i_rank][0] = strtotime($str_date) * 1000;
            }

            $rank_history_time_str = !empty($rank_history) ?
                [
                    [
                        'name' => $term,
                        'colors' => '#3538FE',
                        'data' => $rank_history
                    ]
                ]
                :
                [
                    ['data' => []]
                ];

            if ($update) {

//                foreach ($SEOAIC_OPTIONS[$option_name][$search_engine] as $index => $keyword) {
//
//                    if (!isset($keyword['location'])) {
//                        $SEOAIC_OPTIONS[$option_name][$search_engine][$index]['location'] = $location;
//                        $SEOAIC_OPTIONS[$option_name][$search_engine][$index]['slug'] = $keyword['slug'] . '_' . $this->Slug($location);
//                    }
//
//                    if ($keyword['keyword'] == $term && $keyword['location'] == $location) {
//
//                        $SEOAIC_OPTIONS[$option_name][$search_engine][$index]['language'] = $language;
//                        $SEOAIC_OPTIONS[$option_name][$search_engine][$index]['position'] = isset($result['data'][0]['position']) ? (int)$result['data'][0]['position'] : '';
//                        $SEOAIC_OPTIONS[$option_name][$search_engine][$index]['page'] = $page;
//                        $SEOAIC_OPTIONS[$option_name][$search_engine][$index]['search_page'] = !empty($result['data'][0]['search_page']) ? $result['data'][0]['search_page'] : '';
//                        $SEOAIC_OPTIONS[$option_name][$search_engine][$index]['last_update'] = time();
//                        $SEOAIC_OPTIONS[$option_name][$search_engine][$index]['next_update'] = $next_update;
//                        $SEOAIC_OPTIONS[$option_name][$search_engine][$index]['description'] = $description;
//                        $SEOAIC_OPTIONS[$option_name][$search_engine][$index]['title'] = $title;
//                        $SEOAIC_OPTIONS[$option_name][$search_engine][$index]['article_analysis'] = !empty($article_analysis) ? $article_analysis : [];
//                        $SEOAIC_OPTIONS[$option_name][$search_engine][$index]['historical_rank'] = $rank_history_time_str;
//                    }
//
//                    $last_index = $index;
//                }
//
//                update_option('seoaic_options', $SEOAIC_OPTIONS);
//
//                $this->combine_rank_tracking_positions($term, $position, $page, $location);
//                $this->combine_terms_with_my_rank_competitors($term, $position);
//
//                wp_send_json([
//                    'search_term_data_HTML' => $this->search_term_data_HTML($_REQUEST['index'])
//                ]);
            }

            $loco = isset($result['data'][0]['location']) ? $result['data'][0]['location'] : $location;
            $slug = isset($result['data'][0]['keyword']) ? $this->Slug($result['data'][0]['keyword'] . '_' . $loco) : $this->Slug($term . '_' . $loco);

            $added_terms[] = [
                'keyword' => $keyword,
                'slug' => $slug,
                'index' => $term_index
            ];

            $SEOAIC_OPTIONS[$option_name][$search_engine][] = [
                'keyword' => $keyword,
                'slug' => $slug,
                "position" => $position,
                "added_competitors" => [],
                "parent_term" => isset($parent) ? $parent : '',
                "search_volume" => 0,
                "location" => $loco,
                "language" => $language,
                "page" => $page,
                'search_page' => isset($result['data'][0]['search_page']) ? $result['data'][0]['search_page'] : '',
                "rank_history" => $rank_history_time_str,
                "serp" => [
                    'last_update' => 0,
                    'data' => '',
                ],
                "keyword_suggestions" => [
                    'last_update' => 0,
                    'data' => '',
                ],
                "sub_terms" => [],
                'last_update' => time(),
                'next_update' => $next_update,
                'description' => $description,
                'title' => $title,
                'article_analysis' => $article_analysis,
                'historical_rank' => $rank_history_time_str
            ];

            $this->combine_rank_tracking_positions($keyword, $position, $page, $loco);
            $this->combine_terms_with_my_rank_competitors($keyword, $position);

            // Change index of sub term (move it after parent)
            if (isset($parent)) {
                $termsArray = $SEOAIC_OPTIONS[$option_name][$search_engine];
                $find = 0;
                $move = 0;
                foreach ($termsArray as $i => $val) :
                    if ($val['slug'] == $parent) {
                        $move = intval($i) + 1;
                    }
                endforeach;

                foreach ($termsArray as $i => $val) :
                    if ($val['parent_term'] == $parent) {
                        $find = intval($i);
                    }
                endforeach;

                $termsArray = $this->Move_Index($termsArray, $find, $move);

                $SEOAIC_OPTIONS[$option_name][$search_engine] = $termsArray;

                update_option('seoaic_options', $SEOAIC_OPTIONS);

            }

            $here = '<li>Term "' . esc_html($term) . '" for ' . esc_html($location) . ' - <span class="green">added</span></li>';

        }

        $this->Search_Volume($search_engine, $terms, $location, $option_name);

        $SEOAIC_OPTIONS['search_terms_ready_to_update'] = [];

        update_option('seoaic_options', $SEOAIC_OPTIONS);

        if ($return) {
            return $added_terms;
        }

        if (!$update) {
            wp_send_json($here ? $here : '');
        }

    }

    public function Search_Volume($search_engine, $terms, $location, $single_term_value = false, $option_name = 'search_terms')
    {

        global $SEOAIC_OPTIONS, $SEOAIC;

        if (empty($location)) {
            $location = $SEOAIC->competitors->seoaic_location();
        }

        $language = $SEOAIC->competitors->seoaic_language();

        $data = [
            'keywords' => $terms,
            'location' => $location,
            'language' => $language,
            'mode' => 'auto',
            'email' => $SEOAIC_OPTIONS['seoaic_api_email'],
        ];

        $result = $this->seoaic->curl->init('api/ai/keywords-search-volume', $data, true, true, true);

        if (!empty($result['status']) && $result['status'] === 'success') {

            // filter terms and set search_volume
            foreach ($result['data'] as $keyword) {

                if (isset($SEOAIC_OPTIONS[$option_name][$search_engine]) && is_array($SEOAIC_OPTIONS[$option_name][$search_engine])) {
                    foreach ($SEOAIC_OPTIONS[$option_name][$search_engine] as &$term) {
                        if ($term['slug'] == $this->Slug($keyword['keyword'] . '_' . $location)) {
                            $term['search_volume'] = isset($keyword['search_volume']) ? $keyword['search_volume'] : '-';
                        }
                    }
                }

            }
            if ($single_term_value) {
                return $result['data'][0]['search_volume'] ?? 0;
            }
        }
    }

    public function Move_Index($array, $find, $move)
    {
        $out = array_splice($array, intval($find), 1);
        array_splice($array, intval($move), 0, $out);
        return $array;
    }

    public function combine_rank_tracking_positions($term, $term_position, $page, $location)
    {

        global $SEOAIC;

        $id = $SEOAIC->competitors->our_own_competitor_id($location);

        if (!$id) {
            return;
        }

        $search_terms = $SEOAIC->competitors->get_competitor_field_val($id, 'search_terms');
        $historical_rank = $SEOAIC->competitors->get_competitor_field_val($id, 'historical_rank');
        $competitor_location = $SEOAIC->competitors->get_competitor_field_val($id, 'location');
        $search_terms_keywords = $SEOAIC->competitors->get_search_terms_field_val($id, 'keyword');

        if (!in_array($term, $search_terms_keywords) && $term_position > 0 && $location === $competitor_location) :

            $search_terms[] = [
                'keyword' => $term,
                'position' => intval($term_position),
                'page' => $page,
                'search_volume' => $this->Search_Volume('google', [$term], $competitor_location, true),
                'my_rank' => ''
            ];

            $positions = !empty($historical_rank[0]['metrics']) ? $historical_rank[0]['metrics'] : [];

            if ($term_position >= 1 and $term_position <= 3) {
                $current_positions = !isset($positions['pos_1_3']) ? 0 : $positions['pos_1_3'];
                $historical_rank[0]['metrics']['pos_1_3'] = intval($current_positions) + 1;
            } else if ($term_position >= 4 and $term_position <= 10) {
                $current_positions = !isset($positions['pos_4_10']) ? 0 : $positions['pos_4_10'];
                $historical_rank[0]['metrics']['pos_4_10'] = intval($current_positions) + 1;
            } else if ($term_position >= 11 and $term_position <= 30) {
                $current_positions = !isset($positions['pos_11_30']) ? 0 : $positions['pos_11_30'];
                $historical_rank[0]['metrics']['pos_11_30'] = intval($current_positions) + 1;
            } else if ($term_position >= 31 and $term_position <= 50) {
                $current_positions = !isset($positions['pos_31_50']) ? 0 : $positions['pos_31_50'];
                $historical_rank[0]['metrics']['pos_31_50'] = intval($current_positions) + 1;
            } else if ($term_position >= 51 and $term_position <= 100) {
                $current_positions = !isset($positions['pos_51_100']) ? 0 : $positions['pos_51_100'];
                $historical_rank[0]['metrics']['pos_51_100'] = intval($current_positions) + 1;
            }

            update_term_meta($id, 'search_terms', $search_terms);
            update_term_meta($id, 'historical_rank', $historical_rank);

        endif;
    }

    public function combine_terms_with_my_rank_competitors($term, $position)
    {

        global $SEOAIC;

        $competitors = $SEOAIC->competitors->get_competitors();

        $my_competitor_id = $SEOAIC->competitors->our_own_website_index();

        foreach ($competitors as $competitor) {
            $ID = $competitor->term_id;
            if ($ID === $my_competitor_id) {
                continue;
            }

            $search_terms = $SEOAIC->competitors->get_search_terms($ID);
            foreach ((array)$search_terms as $in => $search_term) {
                if (isset($search_term['keyword']) && $search_term['keyword'] === $term) {
                    $search_terms[$in]['my_rank'] = $position;
                }
            }
            update_term_meta($ID, 'search_terms', $search_terms);
        }
    }


    public function combine_all_ranks()
    {
        global $SEOAIC_OPTIONS, $SEOAIC;
        $search_engine = !isset($_GET['search_engine']) ? 'google' : $_GET['search_engine'];
        foreach ((array)$SEOAIC_OPTIONS['search_terms'][$search_engine] as $term) {
            $SEOAIC->rank->combine_rank_tracking_positions($term['keyword'], $term['position'], $term['page'], $term['location']);
            $SEOAIC->rank->combine_terms_with_my_rank_competitors($term['keyword'], $term['position']);
        }
    }

    // VIEW COMPETITORS IN KEYWORDS END
}