<?php

namespace SEOAIC;

use SEOAIC\content_editor_blocks\providers\SEOAICBlocks;

/**
 * Class is used to init hooks that should be inited only once.
 */

class SEOAICSingleton
{
    protected static $instance = null;
    private $seoaic;

    public function __construct($seoaic)
    {
        global $SEOAIC_OPTIONS;

        $this->seoaic = $seoaic;

        $filterName = version_compare(get_bloginfo('version'), '5.8', '>=') ? 'block_categories_all' : 'block_categories';
        add_filter($filterName, [$this, 'blockCategories']);
        // add_filter('the_content', [$this, 'outputSchemaInContent']);
        add_action('wp_head', [$this, 'outputSchemaInHead'], 2);


        $SeoaicContentImprovementInst = $seoaic->content_improvement;
        if (!empty($SEOAIC_OPTIONS['googleMetaTag'])) {
            add_action('wp_head', [$SeoaicContentImprovementInst, 'addGoogleSiteVerificationMetaTag']);
        }

        add_action('wp_head', [$this, 'customTemplateCSS'], 100);
    }

    public static function get($seoaic) {
        if (
            is_null(self::$instance)
            && !(self::$instance instanceof SEOAICSingleton)
        ) {
            self::$instance = new SEOAICSingleton($seoaic);
        }

        return self::$instance;
    }

    public function blockCategories($categories)
    {
        return array_merge(
            $categories,
            [
                [
                    'slug'  => 'seoaic-blocks',
                    'title' => esc_html__('SEOAI', 'seoaic'),
                    // 'icon'  => 'wordpress',
                ],
            ]
        );
    }

    public function outputSchemaInHead()
    {
        if (
            is_singular()
            && is_main_query()
        ) {
            $blocks = parse_blocks(get_the_content(null, false, get_the_ID()));

            if (
                empty($blocks)
                || !is_array($blocks)
            ) {
                return;
            }

            foreach ($blocks as $block) {
                if (
                    !empty($block['blockName'])
                    && 'seoaic/faq-block' == $block['blockName']
                    && !empty($block['attrs'])
                    && !empty($block['attrs']['questions'])
                ) {
                    $out = [];
                    $instance = new SEOAICBlocks();
                    $faqSchemaInst = $instance->doFAQSchema($block['attrs']['questions']);
                    // error_log('faqSchema '.print_r($faqSchemaInst->getSchema(), true));

                    $out[] = "\n<!-- SEOAI plugin -->";
                    $out[] = $faqSchemaInst->getSchemaScript();
                    $out[] = "<!-- /SEOAI plugin -->\n\n";

                    echo implode("\n", $out);
                }
            }
        }
    }

    // public function outputSchemaInContent($content)
    // {
    //     if (
    //         is_singular()
    //         && in_the_loop()
    //         && is_main_query()
    //     ) {
    //         $blocks = parse_blocks(get_the_content());
    //         if (!empty($blocks)) {
    //             foreach ($blocks as $block) {
    //                 if (
    //                     'seoaic/faq-block' == $block['blockName']
    //                     && !empty($block['attrs'])
    //                     && !empty($block['attrs']['questions'])
    //                 ) {
                        // $instance = new SEOAICBlocks();
                        // echo $instance->makeFAQSchema($block['attrs']['questions']);
    //                     error_log('schema '.print_r($schema, true));
    //                     $content .= $schema;
    //                 }
    //             }
    //         }
    //     }
    //     return $content;
    // }

    public function customTemplateCSS()
    {
        echo "<style>" . SEOAIC_SETTINGS::getCustomTemplateCSS() . "</style>";
    }
}
