<?php

namespace SEOAIC;

class SEOAICAjaxResponse
{
    private $status;
    private $message;
    private $fields;
    private $statusCode;
    private $flags;

    public function __construct()
    {
        $this->status = '';
        $this->message = '';
        $this->fields = [];
        $this->statusCode = null;
        $this->flags = 0;
    }

    /**
     * @param string $msg optional message text
     * @return SEOAICAjaxResponse instanse of class
     */
    public static function success($msg = '')
    {
        $instance = new self();
        $instance->status = 'success';
        $instance->message = $msg;

        return $instance;
    }

    /**
     * @param string $msg optional message text
     * @return SEOAICAjaxResponse instanse of class
     */
    public static function complete($msg = '')
    {
        $instance = new self();
        $instance->status = 'complete';
        $instance->message = $msg;

        return $instance;
    }

    /**
     * @param string $msg optional message text
     * @return SEOAICAjaxResponse instanse of class
     */
    public static function progress($msg = '')
    {
        $instance = new self();
        $instance->status = 'progress';
        $instance->message = $msg;

        return $instance;
    }

    /**
     * @param string $msg optional message text
     * @return SEOAICAjaxResponse instanse of class
     */
    public static function waiting($msg = '')
    {
        $instance = new self();
        $instance->status = 'waiting';
        $instance->message = $msg;

        return $instance;
    }

    /**
     * @param string $msg optional message text
     * @return SEOAICAjaxResponse instanse of class
     */
    public static function alert($msg = '')
    {
        $instance = new self();
        $instance->status = 'alert';
        $instance->message = $msg;

        return $instance;
    }

    /**
     * @return SEOAICAjaxResponse instanse of class
     */
    public static function reload()
    {
        $instance = new self();
        $instance->status = 'reload';

        return $instance;
    }

    /**
     * @param string $msg error message text
     * @return SEOAICAjaxResponse instanse of class
     */
    public static function error($msg)
    {
        $instance = new self();
        $instance->status = 'error';
        $instance->message = $msg;

        return $instance;
    }

    /**
     * Adds additional fields to response
     * @param array $fields additional fields that will be appended to response. Array format: key => value
     * @return SEOAICAjaxResponse current instanse of class
     */
    public function addFields($fields=[])
    {
        if (
            !empty($fields)
            && is_array($fields)
        ) {
            $this->fields = $fields;
        }

        return $this;
    }

    /**
     * Sets $status_code param for wp_send_json
     * @param int $statusCode — Optional. The HTTP status code to output. Default null.
     */
    public function setStatusCode($statusCode)
    {
        $this->statusCode = $statusCode;

        return $this;
    }

    /**
     * Sets $flags param for wp_send_json
     * @param int $flags — Optional. Options to be passed to json_encode(). Default 0.
     */
    public function setFlags($flags)
    {
        $this->flags = $flags;

        return $this;
    }

    /**
     * Sends WP response and dies
     * @return void
     */
    public function wpSend()
    {
        $response = [
            'status' => $this->status,
            'message' => $this->message,
        ];

        if (
            !empty($this->fields)
            && is_array($this->fields)
        ) {
            foreach ($this->fields as $key => $value) {
                $response[$key] = $value;
            }
        }

        wp_send_json($response, $this->statusCode, $this->flags);
    }

     /**
     * @return SEOAICAjaxResponse instanse of class
     */
    public static function redirect()
    {
        $instance = new self();
        $instance->status = 'redirect';

        return $instance;
    }

    /**
     * Create redirect field WP
     * @param string $url
     * @return SEOAICAjaxResponse
     */
    public function redirectTo($url = '', $blank = false)
    {
        $this->addFields(['redirectTo' => $url, 'blank' => $blank])->wpSend();
    }
}
