<?php

namespace SEOAIC\DB;

class LeadAddonTable extends AbstractTable
{
    public function __construct()
    {
        global $wpdb;

        $this->versionField = 'seoaic_leads_db_version';
        $this->tableName = $wpdb->prefix . 'seoaic_leads_addon';
        $this->tableVersion = '1.1'; // change on table update

        parent::__construct();
    }

    public static function createIfNotExists($tableName = '')
    {
        $self = self::getInstance();
        $columns = "
            id bigint(20) unsigned NOT NULL auto_increment,
            status varchar(20) NOT NULL,
            data JSON NOT NULL,
            email_status varchar(10) DEFAULT 'not_sent',
            date DATETIME NOT NULL,
            PRIMARY KEY  (id)";

        return $self->createIfNotExistsTable($self->tableName, $columns);
    }

    public function update_1_1()
    {
        global $wpdb;

        $charset_collate = $wpdb->get_charset_collate();

        $sql = "CREATE TABLE $this->tableName (
            id bigint(20) unsigned NOT NULL auto_increment,
            status varchar(20) NOT NULL,
            data JSON NOT NULL,
            page_url varchar(200) NOT NULL,
            page_title varchar(200) NOT NULL,
            email_status varchar(10) DEFAULT 'not_sent',
            date DATETIME NOT NULL,
            PRIMARY KEY  (id)
        ) $charset_collate;";

        require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
        dbDelta( $sql );

        update_option($this->versionField, $this->tableVersion);
    }
}