<?php

namespace SEOAIC\DB;

class InteractiveArticleAddonTable extends AbstractTable
{
    public function __construct()
    {
        global $wpdb;

        $this->versionField = 'seoaic_interactive_article_db_version';
        $this->tableName = $wpdb->prefix . 'seoaic_interactive_article_addon';
        $this->tableVersion = '1.0'; // change on table update

        parent::__construct();
    }

    public static function createIfNotExists($tableName = '')
    {
        $self = self::getInstance();
        $columns = "
            id bigint(20) unsigned NOT NULL auto_increment,
            post_id bigint(20) unsigned NOT NULL,
            blocks_count int(3) unsigned NOT NULL,
            data JSON NOT NULL,
            date DATETIME NOT NULL,
            PRIMARY KEY  (id)";

        return $self->createIfNotExistsTable($self->tableName, $columns);
    }
}