export async function loadPluginSidebar() {
    try {
        const { PluginSidebar } = await import('@wordpress/editor');

        return { PluginSidebar };
    } catch (primaryError) {
        console.error('Primary import failed, attempting fallback...', primaryError);

        try {
            const { PluginSidebar } = await import('@wordpress/editor');

            return { PluginSidebar };
        } catch (fallbackerror) {
            console.error('Fallback import failed.', fallbackerror)
            throw new Error("No PluginSidebar module could be loaded");
        }
    }
}