import apiFetch from '@wordpress/api-fetch';

const Fetch = {
    get: async (apiPath, callback=false, errorCallback=false) => {
        callback = callback || function() {};
        errorCallback = errorCallback || function() {};

        return apiFetch({
            headers: {
                'X-WP-Nonce': wpApiSettings.nonce
            },
            path: '/seoaic/v1/' + apiPath,
            method: 'GET'
        })
        .then((res) => {
            if (res) {
                callback(res);
            }
        }).catch((res) => {
            errorCallback(res);
        });
    },
    post: async (apiPath, data, callback=false, errorCallback=false) => {
        data = data || {};
        callback = callback || function() {};
        errorCallback = errorCallback || function() {};

        return apiFetch({
            headers: {
                'X-WP-Nonce': wpApiSettings.nonce
            },
            path: '/seoaic/v1/' + apiPath,
            method: 'POST',
            data: data,
        })
        .then((res) => {
            if (res) {
                callback(res);
            }
        }).catch((res) => {
            errorCallback(res);
        });
    },
    put: async (apiPath, data, callback=false, errorCallback=false) => {
        data = data || {};
        callback = callback || function() {};
        errorCallback = errorCallback || function() {};

        return apiFetch({
            headers: {
                'X-WP-Nonce': wpApiSettings.nonce
            },
            path: '/seoaic/v1/' + apiPath,
            method: 'PUT',
            data: data,
        })
        .then((res) => {
            if (res) {
                callback(res);
            }
        }).catch((res) => {
            errorCallback(res);
        });
    },
};

export default Fetch;