<?php
/**
 * Plugin Name:       Content Commands
 * Description:       Addition for SEOAI client Wordpress Plugin, providing commands for blocks content editor (Gutenberg), and SEOAIC sidebar.
 * Requires at least: 6.1
 * Requires PHP:      7.2.7
 * Version:           0.1.1
 * Author:            SEO AI OY
 * License:           GPL-2.0-or-later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       seoaic
 *
 * @package CreateBlock
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Registers the block using the metadata loaded from the `block.json` file.
 * Behind the scenes, it registers also all assets so they can be enqueued
 * through the block editor in the corresponding context.
 *
 * @see https://developer.wordpress.org/reference/functions/register_block_type/
 */
function create_block_content_commands_block_init()
{
	register_block_type(__DIR__ . '/build');
}
add_action( 'init', 'create_block_content_commands_block_init' );
