import { __ } from '@wordpress/i18n';
import { useState, useEffect } from 'react';
import { dispatch, select } from '@wordpress/data';
import {
    Flex,
    FlexBlock,
    FlexItem,
    __experimentalText as Text,
} from '@wordpress/components';
import Fetch from '../../helpers/fetch';
import SidebarSection from '../sidebar-section';
import SidebarSpinner from './sidebar-spinner';
import SidebarNotification from './sidebar-notification';

const InteractiveArticleStatsSidebarSection = () => {
    const [ stats, setStats ] = useState(null);
    const [ interactiveArticleBlocks, setInteractiveArticleBlocks] = useState([]);

    const processResults = (result) => {
        console.log('result', result);
        setStats(result.data);
    };

    useEffect(() => {
        const post = select('core/editor').getCurrentPost();
        const blocks = select('core/editor').getBlocks();
        const interactiveBlocks = [];

        // console.log('blocks', blocks);
        for (let i = 0; i < blocks.length; i++) {
            const block = blocks[i];

            if ('seoaic/interactive-article-block' == block.name) {
                interactiveBlocks.push(block);
            }
        }

        if (0 < interactiveBlocks.length) {
            setInteractiveArticleBlocks(interactiveBlocks);
            Fetch.get('sidebar/' + post.id + '/interactive-article-stats', processResults);
        }
    }, []);

    return (
        <SidebarSection
            title={ __("Interactive Article Statistics", "seoaic") }
            id="interactive_article_stats"
            className="seoaic-sidebar-ia-stats"
        >
            { stats
            ? (
                0 < interactiveArticleBlocks.length
                ? (
                    <>
                        <div className='seoaic-border-dashed-gradient seoaic-text-center seoaic-p-10 seoaic-mb-10'>
                            <div className="seoaic-ia-stats-subtitle seoaic-mb-10">{ __("Total views", "seoaic") }</div>
                            <div className="seoaic-ia-stats-subtitle"><b>{ stats.views }</b></div>
                        </div>
                        <div className='seoaic-border-dashed-gradient seoaic-p-10'>
                            <div className="seoaic-ia-stats-subtitle seoaic-text-center seoaic-mb-10">{ __("Questions statistics:", "seoaic") }</div>
                            { interactiveArticleBlocks.map((interactiveArticleBlock) => {
                                if (stats.sessions_stats[interactiveArticleBlock.attributes.id]) {
                                    const answerViews = stats.sessions_stats[interactiveArticleBlock.attributes.id];
                                    const progressValue = answerViews / stats.views;
                                    const progressValuePercent = Math.round((progressValue) * 100);

                                    return (
                                        <div
                                            className="seoaic-ia-stats-row seoaic-mb-10"
                                        >
                                            <div
                                                className="seoaic-ia-stats-question"
                                            >{ interactiveArticleBlock.attributes.question }</div>
                                            <Flex
                                                className="seoaic-ia-stats-progress-bar-wrapper"
                                            >
                                                <FlexItem
                                                    className="seoaic-ia-question-progress-value"
                                                    title={ answerViews + " / " + stats.views }
                                                    style={{ '--left': progressValuePercent + '%' }}
                                                >
                                                    { progressValuePercent }%
                                                </FlexItem>
                                                <FlexBlock>
                                                    <progress
                                                        value={ progressValue }
                                                        className="seoaic-ia-question-progress-bar"
                                                    />
                                                </FlexBlock>
                                            </Flex>
                                        </div>
                                    );
                                }
                            }) }
                        </div>
                    </>
                )
                : <SidebarNotification type="info">{ __("No interactive article blocks.", "seoaic") }</SidebarNotification>
            )
            : ( <SidebarSpinner/> ) }
        </SidebarSection>
    );
};

export default InteractiveArticleStatsSidebarSection;