import { __ } from '@wordpress/i18n';
import { Modal, Button, Flex, FlexItem } from '@wordpress/components';

const ImprovementTextModal = (props) => {
    return (
        <Modal
            title={ __("Improvement text", "seoaic") }
            size="large"
            shouldCloseOnClickOutside={ false }
            onRequestClose={ props.closeImprovementTextModal }
        >
            <div dangerouslySetInnerHTML={ {__html: props.improvementText} }></div>
            <Flex
                gap={2}
                align="center"
                justify="space-between"
            >
                <FlexItem>
                    <Button
                        variant="secondary"
                        onClick={ props.closeImprovementTextModal }
                    >
                        { __("Close", "seoaic") }
                    </Button>
                </FlexItem>
                <FlexItem>
                    <Button
                        variant="primary"
                        onClick={ () => {
                            props.closeImprovementTextModal();
                            props.addToContent(props.improvementText);
                        } }
                    >
                        { __("Add to content", "seoaic") }
                    </Button>
                </FlexItem>
            </Flex>
        </Modal>
    );
};

export default ImprovementTextModal;