import { __ } from '@wordpress/i18n';
import SidebarSpinner from './sidebar-spinner';
import SidebarSection from '../sidebar-section';
import SidebarNotification from './sidebar-notification';

const ContentInfoSidebarSection = (props) => {
    return (
        <SidebarSection
            title={ __("Content Info", "seoaic") }
            id="content_info"
        >
            <h3>{ __("Main Intent", "seoaic") }</h3>
            { null != props.mainIntent
            ? (
                "" == props.mainIntent
                ? <SidebarNotification type="info">{ __("Nothing here.", "seoaic") }</SidebarNotification>
                : <p>{ props.mainIntent }</p>
            )
            : <SidebarSpinner />
            }

            <h3 style={{ marginTop: '20px' }}>{ __("Target Audience", "seoaic") }</h3>
            { null != props.targetAudience
            ? (
                "" == props.targetAudience
                ? <SidebarNotification type="info">{ __("Nothing here.", "seoaic") }</SidebarNotification>
                : (
                    <div className="seoaic-target-audience-wrapper">
                        { props.targetAudience }
                    </div>
                )
            )
            : <SidebarSpinner />
            }
        </SidebarSection>
    );
};

export default ContentInfoSidebarSection;