import { __ } from '@wordpress/i18n';
import { useEffect, useState } from 'react';
import { select } from '@wordpress/data';
import { addQueryArgs } from '@wordpress/url';
import { ExternalLink } from '@wordpress/components';
import Fetch from '../../helpers/fetch';
import SidebarSpinner from './sidebar-spinner';
import CompetitorsAnalysisTable from './competitors-analysis-table';
import CompetitorPageComparisonModal from '../modal/competitor-page-compare';
import SidebarSection from '../sidebar-section';
import SidebarNotification from './sidebar-notification';

const CompetitorsSidebarSection = (props) => {
    const [ competitorsData, setCompetitorsData ] = useState(null);
    const [ syncLink, setSyncLink ] = useState("");
    const [ isComparisonModalOpen, setComparisonModalOpen ] = useState(false);
    const [ compareURL, setCompareURL ] = useState('');
    const [ topKeyword, setTopKeyword ] = useState('');

    const postStatus = select('core/editor').getEditedPostAttribute('status');
    const isPublished = 'publish' == postStatus;

    useEffect(() => {
        const post = select('core/editor').getCurrentPost();
        setSyncLink("admin.php?page=seoaic-content-improvement&search=" + post.title);

        if (
            "undefined" !== typeof props.keywords
            && props.keywords.length
            && !competitorsData
        ) {
            setTopKeyword(props.keywords[0].title);

            if ('' != topKeyword) {
                const queryParams = {
                    keyword: topKeyword
                };
                const postPath = addQueryArgs('sidebar/' + post.id + '/top-competitors-analysis', queryParams);

                Fetch.get(postPath, (res) => {
                    setCompetitorsData(res.data);
                });
            }
        }
    }, [props.keywords, props.areKeywordsFetched, topKeyword]);

    return (
        <SidebarSection
            title={ __("Competitors", "seoaic") }
            id="seoaic_competitors"
        >
            { competitorsData
            ? (
                props.keywords.length
                && 0 < competitorsData.length
                ? (
                    <CompetitorsAnalysisTable
                        competitorsData={ competitorsData }
                        setCompareURL={ setCompareURL }
                        setComparisonModalOpen={ setComparisonModalOpen }
                    />
                )
                : (
                    <ExternalLink href={ syncLink }>{ __('Sync data', 'seoaic') }</ExternalLink>
                )
            )
            : (
                props.keywords.length
                ? <SidebarSpinner />
                : <SidebarNotification type="warning">{ __("Can't load competitors.", "seoaic") }</SidebarNotification>
            ) }

            {
                isPublished
                && isComparisonModalOpen
                &&
                ( <CompetitorPageComparisonModal
                    compareURL={ compareURL }
                    topKeyword={ topKeyword }
                    close={ function() {
                        setComparisonModalOpen(false);
                    } }
                /> )
            }
        </SidebarSection>
    );
};

export default CompetitorsSidebarSection;