import { __ } from '@wordpress/i18n';
import { select } from '@wordpress/data';

const CompetitorsAnalysisTable = (props) => {
    const postStatus = select('core/editor').getEditedPostAttribute('status');
    const isPublished = 'publish' == postStatus;
    const publishedTip = __("Tip: click on the competitor's name to see detailed comparison.", 'seoaic');
    const notPublishedTip = __('Tip: publish your post to be able to compare it with competitors.', 'seoaic');

    return (
        <>
        <div className="seoaic-compare-tip">{ isPublished ? publishedTip : notPublishedTip }</div>
        <div className="seoaic-sidebar-table seoaic-competitors-table">
            <div className="seoaic-sidebar-table-row seoaic-sidebar-table-header d-grid">
                <div>Competitor</div>
                <div>Words</div>
                <div>H2</div>
            </div>
            {props.competitorsData.map((obj, i) => {
                const title = isPublished ? __("Open comparison for ", "seoaic") + obj.domain : '';
                const className = isPublished ? 'seoaic-sidebar-competitor-title clickable' : 'seoaic-sidebar-competitor-title';
                const clickFunction = isPublished ? () => {
                    props.setCompareURL(obj.pageURL);
                    props.setComparisonModalOpen(true);
                } : () => {};

                return (
                    <div className="seoaic-sidebar-table-row d-grid">
                        <div>
                            <span
                                className={ className }
                                title={ title }
                                onClick={ clickFunction }
                            >{ obj.domain }</span>
                        </div>
                        <div>{ obj.wordscount }</div>
                        <div>{ obj.h2 }</div>
                    </div>
                );
            })}
        </div>
        </>
    );
};

export default CompetitorsAnalysisTable;