import { __ } from '@wordpress/i18n';
import { Modal, Flex, FlexBlock, __experimentalText as Text, TextareaControl, Button } from '@wordpress/components';
import InProgressPlaceholder from '../in-progress-placeholder';

const TextComparisonModal = ({
    originalText,
    generatedText,
    setGeneratedText,
    isGenerating,
    handleAcceptText,
    handleReprompt,
    handleCloseComparisonTextModal,
    openImproveContentModal,
    lastCommand
}) => {
    const handleRepromptFunc = "improveContent" == lastCommand.command ? openImproveContentModal : handleReprompt;

    return (
        <Modal
            shouldCloseOnEsc
            shouldCloseOnClickOutside={ false }
            title={ lastCommand.title + ' - ' + __("Text Verification", "seoaic") }
            size='large'
            onRequestClose={ handleCloseComparisonTextModal }
            className="seoaic-verification-modal"
        >
            <Flex
                align="center"
                justify="space-between"
            >
                <FlexBlock>
                    <Text
                        isBlock
                        as="h2"
                        align="center"
                        className="seoaic-verification-subtitle"
                    >{ __("Original text", "seoaic") }</Text>
                </FlexBlock>
                <FlexBlock>
                    <Text
                        isBlock
                        as="h2"
                        align="center"
                        className="seoaic-verification-subtitle"
                    >{ __("AI-generated text", "seoaic") }</Text>
                </FlexBlock>
            </Flex>
            <Flex
                gap={3}
                align="center"
                justify="space-between"
                className="seoaic-verification-texts-flex"
            >
                <FlexBlock>
                    <p className="seoaic-verification-text">{ originalText }</p>
                </FlexBlock>
                <FlexBlock>
                    {
                    isGenerating
                    ? (<InProgressPlaceholder/>)
                    : (<TextareaControl
                            className="seoaic-verification-textarea"
                            value={ generatedText }
                            onChange={ (val) => {
                                setGeneratedText(val);
                            } }
                        />)
                    }
                </FlexBlock>
            </Flex>
            <Flex
                gap={2}
                align="center"
                justify="space-between"
            >
                <FlexBlock>
                    <Button
                        onClick={ handleCloseComparisonTextModal }
                        variant='secondary'
                    >
                        { __("Decline", "seoaic") }
                    </Button>
                </FlexBlock>
                <FlexBlock
                    className="seoaic-text-right"
                >
                    <Button
                        onClick={ handleRepromptFunc }
                        variant='primary'
                        disabled={ isGenerating }
                        className="seoaic-mr-20"
                        label={ __("Run the command again.", "seoaic") }
                        showTooltip={ true }
                    >
                        { __("Reprompt", "seoaic") }
                    </Button>
                    <Button
                        onClick={ handleAcceptText }
                        variant='primary'
                        disabled={ isGenerating }
                        label={ __("Accept the AI-generated text and replace the original text with it.", "seoaic") }
                        showTooltip={ true }
                    >
                        { __("Accept", "seoaic") }
                    </Button>
                </FlexBlock>
            </Flex>
        </Modal>
    );
};

export default TextComparisonModal;