import { Modal, ButtonGroup, Button } from '@wordpress/components';
import { __ } from '@wordpress/i18n';

const RewriteModal = (props) => {
    return (
        <Modal title={ __('Rewrite Block', 'seoaic') } onRequestClose={ props.close }>
            <ButtonGroup>
                <Button
                    variant="primary"
                    onClick={ () => {
                        props.onRewriteModeChange('experts');
                    }}
                >{ __("Rewrite For Experts", "seoaic") }</Button>
                <Button
                    variant="primary"
                    onClick={ () => {
                        props.onRewriteModeChange('beginners');
                    } }
                >{ __("Rewrite For Beginners", "seoaic") }</Button>
            </ButtonGroup>
        </Modal>
    );
}

export default RewriteModal;