import { Modal, ButtonGroup, Button } from '@wordpress/components';
import { __ } from '@wordpress/i18n';

const MakeItMoreModal = (props) => {
    const buttonsGroups = [
        [
            {label: __("Detailed", "seoaic"), value: 'detailed'},
            {label: __("Descriptive", "seoaic"), value: 'descriptive'},
            {label: __("Engaging", "seoaic"), value: 'engaging'},
            {label: __("Generic", "seoaic"), value: 'generic'},
        ]
    ];

    return (
        <Modal
            title={ __('Make It More', 'seoaic') }
            onRequestClose={ props.close }
            className="seoaic-make-it-more-modal"
        >
            { buttonsGroups.map((group, index) => {
                return <div className="seoaic-make-it-more-buttons-row">
                    <ButtonGroup>
                        { group.map((item, index) => {
                            return <Button
                                variant="primary"
                                onClick={ () => {
                                    props.onStyleChange(item.value);
                                }}
                            >{ item.label }</Button>
                        }) }
                    </ButtonGroup>
                </div>
            }) }
        </Modal>
    );
}

export default MakeItMoreModal;