import { Modal, TextareaControl, Button, Flex } from '@wordpress/components';
import PromptsHistory from '../prompts-history.js';
import { __ } from '@wordpress/i18n';

const ImproveContentModal = (props) => {
    return (
        <Modal
            title={ __('Improve Content', 'seoaic') }
            onRequestClose={ props.close }
            className="seoaic-improve-content-modal"
        >
            <TextareaControl
                label={ __('Prompt', 'seoaic') }
                help=""
                required
                className="improve-content-prompt-field"
                value={ props.promptValue }
                onChange={ (value) => {
                    props.setPrompt(value);
                } }
            />
            <PromptsHistory
                setPromptField={ props.setLastUsedPrompt }
            />
            <Flex
                gap={2}
                align="center"
                justify="space-between"
            >
                <Button
                    variant="secondary"
                    onClick={ props.close }
                >{ __('Cancel', 'seoaic') }</Button>
                <Button
                    variant="primary"
                    onClick={ props.submit }
                >{ __('Submit', 'seoaic') }</Button>
            </Flex>
        </Modal>
    );
}

export default ImproveContentModal;