import { __ } from '@wordpress/i18n';
import { useState, useEffect } from 'react';
import { select } from '@wordpress/data';
import { Modal } from '@wordpress/components';
import Fetch from '../../helpers/fetch';
import { addQueryArgs } from '@wordpress/url';
import SidebarSpinner from '../sidebar/sidebar-spinner';

const CompetitorPageComparisonModal = (props) => {
    const [ postData, setPostData ] = useState({});
    const [ compareData, setCompareData ] = useState({});
    const [ suggestionData, setSuggestionData ] = useState({});

    const permalink = select('core/editor').getPermalink();
    const post = select('core/editor').getCurrentPost();

    useEffect(() => {
        if (
            '' != props.compareURL
            && '' != props.topKeyword
        ) {
            const postQueryParams = {
                page_url: permalink,
                keyword: props.topKeyword
            };
            const postPath = addQueryArgs('sidebar/' + post.id + '/competitor-comparison', postQueryParams);
            Fetch.get(postPath, (res) => {
                if ("undefined" !== typeof res.data) {
                    setPostData(res.data);
                }
            });


            const comapreQueryParams = {
                page_url: props.compareURL,
                keyword: props.topKeyword
            };
            const comparePath = addQueryArgs('sidebar/' + post.id + '/competitor-comparison', comapreQueryParams);

            Fetch.get(comparePath, (res) => {
                if ("undefined" !== typeof res.data) {
                    setCompareData(res.data);
                }
            });


            const suggestionQueryParams = {
                page_url: props.compareURL,
                competitor_page_url: props.compareURL,
                keyword: props.topKeyword
            };
            const suggestionPath = addQueryArgs('sidebar/' + post.id + '/ai-suggestions', suggestionQueryParams);

            Fetch.get(suggestionPath, (res) => {
                if ("undefined" !== typeof res.data) {
                    setSuggestionData(res.data);
                }
            });
        }
    }, [props.compareURL, props.topKeyword]);

    return (
        <Modal
            title={ __('Comparison', 'seoaic') }
            onRequestClose={ props.close }
            size='fill'
        >
            <div id="seoaic_editor_analyze_table" className="table">
                <div className="body">
                    <div className="page-urls">
                        <div className="url post-url">
                            <a target="_blank" href={ permalink }><span>{ permalink }</span></a>
                        </div>
                        <div className="url competitor-url">
                            <a target="_blank" href={ props.compareURL }><span>{ props.compareURL }</span></a>
                        </div>
                    </div>
                    <div className="columns">
                        <div className="post-data">
                            { Object.keys(postData).length && "undefined" !== typeof postData.html ? (
                                <div dangerouslySetInnerHTML={ {__html: postData.html} }></div>
                            ) : (
                                <SidebarSpinner />
                            ) }
                        </div>
                        <div className="competitor-data">
                            { Object.keys(compareData).length && "undefined" !== typeof compareData.html ? (
                                <div dangerouslySetInnerHTML={ {__html: compareData.html} }></div>
                            ) : (
                                <SidebarSpinner />
                            ) }
                        </div>
                    </div>

                    <div className="ai-suggestion">
                        { Object.keys(suggestionData).length && "undefined" !== typeof suggestionData.html ? (
                                <div dangerouslySetInnerHTML={ {__html: suggestionData.html} }></div>
                            ) : (
                                <SidebarSpinner />
                            ) }
                    </div>
                </div>
            </div>
        </Modal>
    );
}

export default CompetitorPageComparisonModal;