import { Modal, ButtonGroup, Button } from '@wordpress/components';
import { __ } from '@wordpress/i18n';

const ChangeToneModal = (props) => {
    const buttonsGroups = [
        [
            {label: __("Academic", "seoaic"), value: 'academic'},
            {label: __("Creative", "seoaic"), value: 'creative'},
            {label: __("Professional", "seoaic"), value: 'professional'},
            {label: __("Funny", "seoaic"), value: 'funny'},
        ], [
            {label: __("Serious", "seoaic"), value: 'serious'},
            {label: __("Friendly", "seoaic"), value: 'friendly'},
            {label: __("Compelling", "seoaic"), value: 'compelling'},
            {label: __("Engaging", "seoaic"), value: 'engaging'},
        ], [
            {label: __("Happy", "seoaic"), value: 'happy'},
            {label: __("Persuasive", "seoaic"), value: 'persuasive'},
            {label: __("Authoritative", "seoaic"), value: 'authoritative'},
            {label: __("Sarcastic", "seoaic"), value: 'sarcastic'},
        ],
    ];

    return (
        <Modal
            title={ __('Change Tone To', 'seoaic') }
            onRequestClose={ props.close }
            className="seoaic-change-tone-modal"
        >
            { buttonsGroups.map((group, index) => {
                return <div className="seoaic-change-tone-buttons-row">
                    <ButtonGroup>
                        { group.map((item, index) => {
                            return <Button
                                variant="primary"
                                onClick={ () => {
                                    props.onToneChange(item.value);
                                }}
                            >{ item.label }</Button>
                        }) }
                    </ButtonGroup>
                </div>
            }) }
        </Modal>
    );
}

export default ChangeToneModal;