/**
 * Registers a new block provided a unique name and an object defining its behavior.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-registration/
 */

/**
 * Lets webpack process CSS, SASS or SCSS files referenced in JavaScript files.
 * All files containing `style` keyword are bundled together. The code used
 * gets applied both to the front of your site and to the editor.
 *
 * @see https://www.npmjs.com/package/@wordpress/scripts#using-css
 */

import './style.scss';

/**
 * Internal dependencies
*/
import Edit from './edit';
import Save from './save';
import deprecated from './deprecated';
import metadata from './block.json';
import { __ } from '@wordpress/i18n';
import { registerBlockType } from '@wordpress/blocks';


/**
 * Every block starts by registering a new block type definition.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-registration/
 */
registerBlockType( metadata.name, {
    keywords: [__("Form", "seoaic"), __("Multistep", "seoaic"), __("Multistep Form", "seoaic"), __("Lead", "seoaic"), __("Lead Form", "seoaic"), __("Yoast", "seoaic"), __("Rank Math", "seoaic")],
    attributes: {
        steps: {
            type: "array"
        },
        position: {
            type: "string"
        },
        redirectURL: {
            type: "string"
        }
    },
    edit: Edit,
    save: Save,
    deprecated,
} );
