import { __ } from '@wordpress/i18n';
import { dispatch } from '@wordpress/data';
import {
    Button,
} from '@wordpress/components';
import StepNumber from "./step-number";
import MoveButtons from './move-buttons';


const StepHeader = ({
    steps,
    currentStep,
    index,
    removeStep,
    setStepField,
    moveStepUp,
    moveStepDown,
    questionLockName,
}) => {
    return (
        <div className="seoaic-ms-step-header">
            { currentStep.collapsed
            ? (
                // do not collapse first step
                0 != index
                ? ( <Button
                    variant="tertiary"
                    icon="arrow-down-alt2"
                    onClick={ (value) => setStepField(currentStep.id, 'collapsed', false) }
                    title={ __("Expand", "seoaic") }
                    className="seoaic-ms-collapse-btn"
                ></Button> )
                : ''
            )
            : (
                0 != index
                ? ( <Button
                    variant="tertiary"
                    icon="arrow-up-alt2"
                    onClick={ (value) => setStepField(currentStep.id, 'collapsed', true) }
                    title={ __("Collapse", "seoaic") }
                    className="seoaic-ms-collapse-btn"
                ></Button> )
                : ''
            ) }
            <MoveButtons
                index={ index }
                itemsCount={ steps.length }
                moveUp={ moveStepUp }
                moveDown={ moveStepDown }
            />
            <StepNumber
                index={ index }
            />
            { 1 < steps.length
            ? (
                <Button
                    label={ __('Remove', 'seoaic') }
                    icon="dismiss"
                    className="seoaic-multistep-remove-btn"
                    onClick={ () => {
                        dispatch('core/notices').removeNotice(questionLockName);
                        removeStep(currentStep.id);
                    } }
                ></Button>
            )
            : '' }
        </div>
    );
};

export default StepHeader;