import { __ } from '@wordpress/i18n';
import { dispatch } from '@wordpress/data';
import {
    RadioControl,
} from '@wordpress/components';
import { RichText } from '@wordpress/block-editor'
import AnswerComponent from './answer-component';

const StepBody = ({
    steps,
    currentStep,
    currentIndex,
    setStepField,
    updateSteps,
    questionLockName,
}) => {
    const formOptionsTypes = [
        { label: __('Message (text)', 'seoaic'), value: 'text' },
        { label: __('Single Choice (buttons)', 'seoaic'), value: 'single' },
        { label: __('Multi Choice (checkboxes)', 'seoaic'), value: 'multi' },
        { label: __('Open Text Field', 'seoaic'), value: 'textfield' },
        { label: __('Contact Form Fields', 'seoaic'), value: 'contact_fields' },
    ];

    const stepTypeChange = (step, value) => {
        const updStepFields = steps.map((stepItem, index) => {
            if (stepItem.id === step.id) {
                let updStep = {...stepItem, ['type']: value};

                updStep = {...updStep, ['formItems']: []};
                updStep = {...updStep, ['buttons']: []};

                return updStep;
            }

            return stepItem;
        });

        updateSteps(updStepFields);
    };

    if (!currentStep.question) {
        dispatch('core/notices').createNotice(
            'error',
            '[Multistep Leads Form] Step ' + currentStep.id + ': ' + __('question is required', 'seoaic'),
            { id: questionLockName, isDismissible: true }
        );

    } else {
        dispatch('core/notices').removeNotice(questionLockName);
    }

    return (
        <div className="seoaic-ms-step-content">
            <RichText
                tagName="div"
                allowedFormats={ [] }
                value={ currentStep.question }
                placeholder={ __('Question / Message', 'seoaic') }
                onChange={ (value) => setStepField(currentStep.id, 'question', value) }
                className="seoaic-faq-question"
            />
            <RadioControl
                label={ __("Form options type", "seoaic") }
                selected={ currentStep.type }
                options={ formOptionsTypes }
                onChange={ (value) => stepTypeChange(currentStep, value) }
                className="seoaic-ms-options-type"
            />
            <div className="seoaic-ms-step-form-wrapper">
                <AnswerComponent
                    selectedOptionType={ currentStep.type }
                    steps={ steps }
                    currentStep={ currentStep }
                    currentIndex={ currentIndex }
                    setStepField={ setStepField }
                />
            </div>
        </div>
    );
};

export default StepBody;