import { __ } from '@wordpress/i18n';
import { SelectControl, TextControl } from '@wordpress/components';

const BlockSettings = ({
    attributes,
    setAttributes,
}) => {
    const setBlockPosition = (value) => {
        setAttributes({
            position: value
        });
    }

    const setRedirectURL = (value) => {
        setAttributes({
            redirectURL: value
        });
    };

    return (
        <div className="seoaic-ms-block-settings">
            <TextControl
                label={ __("Redirect URL") }
                help={ __("Optional. A URL that will be opened after user passes all the form steps.") }
                type="url"
                value={ attributes.redirectURL }
                onChange={ value => setRedirectURL(value) }
            />
            <SelectControl
                label={ __("Position on a page", "seoaic") }
                help={ __("Position of the form on the page.") }
                value={ attributes.position }
                options={ [
                    { label: __("In content", "seoaic"), value: 'in_content' },
                    { label: __("Bottom-right corner (chat-alike)", "seoaic"), value: 'corner' },
                ] }
                onChange={ value => setBlockPosition(value) }
                __next40pxDefaultSize
                __nextHasNoMarginBottom
            />
        </div>
    );
};

export default BlockSettings;