import { __ } from '@wordpress/i18n';
import StepRepeater from './step-repeater';
import ModeSelector from './mode-selector';
import GradientButton from '../../generate-image/components/gradient-button';
import GenerateLeadsForm from './generate-leads-form';

const MultistepLeadFormBlock = ({
    attributes,
    setAttributes,
    questionLockPrefix,
}) => {
    const manualMode = 'manual';
    const generateMode = 'generate';
    const stepTmpltObj = {
        id: '#1',
        question: '',
        type: '',
        formItems: [],
        buttons: [],
        autostep: '',
        collaped: false,
    };
    // const steps = attributes.steps || [stepTmpltObj];
    const steps = attributes.steps || [];

    const addStep = () => {
        const idNumber = +steps[steps.length - 1].id.replace('#', '');

        setAttributes({ steps: [
            ...attributes.steps,
            {
                id: '#' + (idNumber + 1),
                question: '',
                type: '',
                formItems: [],
                buttons: [],
                autostep: '',
                collapsed: false
            }
        ] });
    };

    const updateSteps = (values) => {
        setAttributes({ steps: values });
    };

    const removeStep = (id) => {
        let filteredQuestions = steps.filter((item) => {
            return id !== item.id;
        });

        if (!filteredQuestions.length) { // reset the last item to the default
            filteredQuestions = [questionTmpltObj];
        }

        setAttributes({ steps: filteredQuestions });
    };

    const setGenerateMode = () => {
        setAttributes({ mode: generateMode });
    };

    const setManualMode = () => {
        setAttributes({
            mode: manualMode,
            steps: [stepTmpltObj]
        });
    };

    return (
        <div className="seoaic-multistep-lead-block">
            <ModeSelector
                attributes={ attributes }
                stepsLength={ steps.length}
                setGenerateMode={ setGenerateMode }
                setManualMode={ setManualMode }
            />
            {
                (
                    manualMode == attributes.mode
                    || 0 < steps.length
                )
                ? <>
                    <StepRepeater
                        steps={ steps }
                        updateSteps={ updateSteps }
                        removeStep={ removeStep }
                        questionLockPrefix={ questionLockPrefix }
                    />
                    <GradientButton
                        icon="insert"
                        label={ __("New Step", "seoaic") }
                        onClick={ addStep }
                    />
                </>
                : (
                    generateMode == attributes.mode
                    || 0 < steps.length
                )
                && <GenerateLeadsForm
                    attributes={ attributes }
                    setAttributes={ setAttributes }
                    manualMode={ manualMode }
                />
            }
        </div>
    );
};

export default MultistepLeadFormBlock;