import { __ } from '@wordpress/i18n';
import {
    Button,
    Flex,
    FlexItem,
} from '@wordpress/components';

const MoveButtons = ({
    index,
    itemsCount,
    moveUp,
    moveDown,
}) => {

    return (
        <Flex
            gap={ 0 }
            className="seoaic-ms-move-btns-container"
        >
            <FlexItem>
            {
                index < itemsCount - 1
                && <Button
                        icon="arrow-down"
                        title={ __("Move down", "seoaic") }
                        onClick={ () => moveDown(index) }
                    ></Button>
                }
            </FlexItem>
            <FlexItem>
            {
                0 < index
                && <Button
                        icon="arrow-up"
                        title={ __("Move up", "seoaic") }
                        onClick={ () => moveUp(index) }
                    ></Button>
                }
            </FlexItem>
        </Flex>
    );
};

export default MoveButtons;