import { __ } from "@wordpress/i18n";
import { Flex, FlexItem } from "@wordpress/components";
import GradientButton from "../../generate-image/components/gradient-button";

const ModeSelector = ({
  attributes,
  stepsLength,
  setGenerateMode,
  setManualMode,
}) => {
  return (
    !attributes.mode &&
    1 > stepsLength && (
      <>
        <Flex
          justify="space-evenly"
          className="seoaic-ms-mode-selector-wrapper"
        >
          <FlexItem>
            <GradientButton
              icon="admin-generic"
              label={__("Generate", "seoaic")}
              onClick={setGenerateMode}
            />
          </FlexItem>
          <FlexItem>
            <GradientButton
              icon="welcome-widgets-menus"
              label={__("Create manually", "seoaic")}
              onClick={setManualMode}
            />
          </FlexItem>
        </Flex>
      </>
    )
  );
};

export default ModeSelector;
