import { __ } from '@wordpress/i18n';
import { Flex, FlexBlock, FlexItem } from '@wordpress/components';

const DoubleRangeSlider = ({
    min,
    max,
    step=1,
    label="Range",
    rangeMin,
    setRangeMin,
    rangeMax,
    setRangeMax,
 }) => {
    const handleMinChange = (e) => {
        const val = +e.target.value;

        if (val < rangeMax) {
            setRangeMin(val);
        }
    };
    const handleMaxChange = (e) => {
        const val = +e.target.value;

        if (val > rangeMin) {
            setRangeMax(val);
        }
    };

    return (
        <div className="seoaic-range-container">
            <label className="seoaic-double-range-label">{ label }</label>
            <Flex align="center">
                <FlexItem>
                    <input
                        type="number"
                        className="form_control_container__time__input"
                        value={ rangeMin }
                        min={ min }
                        max={ max }
                        onChange={ handleMinChange }
                    />
                </FlexItem>
                <FlexBlock>
                    <div className="seoaic-range-sliders-control">
                        <input
                            type="range"
                            class="seoaic-range-slider-from"
                            min={ min }
                            max={ max }
                            step={ step }
                            value={ rangeMin }
                            onChange={ handleMinChange }
                        />
                        <input
                            type="range"
                            min={ min }
                            max={ max }
                            step={ step }
                            value={ rangeMax }
                            onChange={ handleMaxChange }
                        />
                    </div>
                </FlexBlock>
                <FlexItem>
                    <input
                        type="number"
                        value={ rangeMax }
                        min={ min }
                        max={ max }
                        onChange={ handleMaxChange }
                    />
                </FlexItem>
            </Flex>
        </div>
    );
};

export default DoubleRangeSlider;