import { __ } from '@wordpress/i18n';
import { useState, useEffect } from 'react';
import {
    Button,
    TextControl,
    SelectControl,
    Flex,
    FlexBlock,
    FlexItem,
    Dashicon,
    __experimentalText as Text
} from '@wordpress/components';
import TopSpace from '../top-space';
import MoveButtons from '../move-buttons';

const SingleChoice = ({
    steps,
    currentStep,
    CTAStepsOptions,
    addButton,
    updateButton,
    removeButton,
    moveItemUp,
    moveItemDown,
}) => {
    const singleChoiceButtonTmpt = {
        text: '',
        step: null
    };

    useEffect(() => {
        if (0 == currentStep.buttons.length) {
            addButton(singleChoiceButtonTmpt);
        }
    }, [steps]);

    return (
        <>
            <TopSpace>
                <Text
                    variant="caption"
                    size={ 11 }
                    weight={ 500 }
                    upperCase={ true }
                    isBlock={ true }
                    color="#000"
                >{ __("Options / buttons:", "seoaic") }</Text>
            </TopSpace>
            { currentStep.buttons.map((item, i) =>
                <div
                    className="seoaic-multistep-form-option"
                >
                    <Flex
                        gap={2}
                        align="center"
                        justify="space-between"
                        className="seoaic-ms-single-option-row"
                    >
                        <FlexItem>
                            <MoveButtons
                                index={ i }
                                itemsCount={ currentStep.buttons.length }
                                moveUp={ () => moveItemUp('buttons', i) }
                                moveDown={ () => moveItemDown('buttons', i) }
                            />
                        </FlexItem>
                        <FlexBlock>
                            <TextControl
                                label={ __('Text:', 'seoaic') }
                                value={ item.text }
                                onChange={ newValue => updateButton(i, 'text', newValue) }
                                type="text"
                                placeholder={ __("Button text", "seoaic") }
                                __nextHasNoMarginBottom
                            />
                        </FlexBlock>
                        <FlexBlock>
                            <SelectControl
                                label={ __('Step:', 'seoaic') }
                                value={ item.step }
                                onChange={ newValue => updateButton(i, 'step', newValue) }
                                options={ CTAStepsOptions }
                                __nextHasNoMarginBottom
                            />
                        </FlexBlock>
                        <FlexItem>
                            <Button
                                className="seoaic-multistep-remove-choice-btn"
                                title={ __("Remove choice", "seoaic") }
                                variant="tertiary"
                                onClick={ () => removeButton(i) }
                            ><Dashicon icon="remove" /></Button>
                        </FlexItem>
                    </Flex>
                </div>
            ) }
            <Button
                className="seoaic-multistep-add-choice-btn"
                title={ __("Add new choice", "seoaic") }
                variant="tertiary"
                onClick={ () => addButton(singleChoiceButtonTmpt) }
            ><Dashicon icon="insert" />&nbsp;{ __("New option", "seoaic") }</Button>
        </>
    );
};

export default SingleChoice;