import { useState, useEffect } from 'react';
import { __ } from '@wordpress/i18n';
import {
    TextareaControl,
    TextControl,
    SelectControl,
    Flex,
    FlexBlock,
    __experimentalText as Text
} from '@wordpress/components';
import TopSpace from '../top-space';

const OpenTextField = ({
    steps,
    currentStep,
    CTAStepsOptions,
    setFormItems,
    updateFormItem,
    addButton,
    updateButton
})=> {
    const buttonTmpt = {
        text: '',
        step: null
    };

    const textareaTmpt = {
        type: 'textarea',
        placeholder: __("Your answer", "")
    };

    useEffect(() => {
        if (0 == currentStep.formItems.length) {
            setFormItems([textareaTmpt]);
        }

        if (0 == currentStep.buttons.length) {
            addButton(buttonTmpt);
        }
    }, [steps]);

    return (
        <>
            <TopSpace>
                <TextareaControl
                    label={ __("User's input field (preview):", "seoaic") }
                    help={ __("A preview of the textarea for user's input. You can save placeholder inside.","seoaic") }
                    rows={3}
                    value={ currentStep.formItems[0]?.placeholder }
                    onChange={ newValue => updateFormItem(0, 'placeholder', newValue) }
                />
            </TopSpace>
            <TopSpace>
                <Text
                    variant="caption"
                    size={ 11 }
                    weight={ 500 }
                    upperCase={ true }
                    isBlock={ true }
                    color="#000"
                >{ __("Next step button:", "seoaic") }</Text>
            </TopSpace>
            <Flex
                gap={2}
                align="center"
                justify="space-between"
                className="seoaic-multistep-form-option"
            >
                <FlexBlock>
                    <TextControl
                        label={ __('Text:', 'seoaic') }
                        value={ currentStep.buttons[0]?.text ?? '' }
                        onChange={ newValue => updateButton(0, 'text', newValue) }
                        type="text"
                        placeholder={ __("Button text", "seoaic") }
                    />
                </FlexBlock>
                <FlexBlock>
                    <SelectControl
                        label={ __('Step:', 'seoaic') }
                        value={ currentStep.buttons[0]?.step ?? '' }
                        onChange={ newValue => updateButton(0, 'step', newValue) }
                        options={ CTAStepsOptions }
                    />
                </FlexBlock>
            </Flex>
        </>
    );
};

export default OpenTextField;