import { __ } from '@wordpress/i18n';
import { useState, useEffect } from 'react';
import {
    Button,
    TextControl,
    SelectControl,
    Flex,
    FlexBlock,
    FlexItem,
    __experimentalText as Text,
    Dashicon
} from '@wordpress/components';
import TopSpace from '../top-space';
import MoveButtons from '../move-buttons';

const MultiChoice = ({
    steps,
    currentStep,
    CTAStepsOptions,
    addFormItem,
    setFormItems,
    updateFormItem,
    removeFormItem,
    addButton,
    updateButton,
    moveItemUp,
    moveItemDown,
}) => {
    const checkboxTmpt = {
        type: 'checkbox',
        text: '',
    };

    const buttonTmpt = {
        text: '',
        step: null
    };

    useEffect(() => {
        if (0 == currentStep.formItems.length) {
            setFormItems([checkboxTmpt]);
        }

        if (0 == currentStep.buttons.length) {
            addButton(buttonTmpt);
        }
    }, [steps]);

    return (
        <>
            <TopSpace>
                <Text
                    variant="caption"
                    size={ 11 }
                    weight={ 500 }
                    upperCase={ true }
                    isBlock={ true }
                    color="#000"
                >{ __("Options:", "seoaic") }</Text>
            </TopSpace>
            { currentStep.formItems.map((item, i) =>
                <div
                    className="seoaic-multistep-form-option"
                >
                    <Flex
                        gap={2}
                        align="center"
                        justify="space-between"
                        className="seoaic-ms-multi-option-row"
                    >
                        <FlexItem>
                            <MoveButtons
                                index={ i }
                                itemsCount={ currentStep.formItems.length }
                                moveUp={ () => moveItemUp('formItems', i) }
                                moveDown={ () => moveItemDown('formItems', i) }
                            />
                        </FlexItem>
                        <FlexBlock>
                            <TextControl
                                value={ item.text }
                                onChange={ newValue => updateFormItem(i, 'text', newValue) }
                                type="text"
                                className="seoaic-ms-multi-option-input"
                                placeholder={ __("Option text", "seoaic") }
                                __nextHasNoMarginBottom
                            />
                        </FlexBlock>
                         <FlexItem>
                            <Button
                                className="seoaic-multistep-remove-choice-btn"
                                title={ __("Remove choice", "seoaic") }
                                variant="tertiary"
                                onClick={ () => removeFormItem(i) }
                            ><Dashicon icon="remove" /></Button>
                        </FlexItem>
                    </Flex>
                </div>
            ) }

            <Button
                className="seoaic-multistep-add-choice-btn"
                title={ __("Add new option", "seoaic") }
                variant="tertiary"
                onClick={ () => addFormItem(checkboxTmpt) }
            ><Dashicon icon="insert" />&nbsp;{ __("New option", "seoaic") }</Button>

            <TopSpace>
                <Text
                    variant="caption"
                    size={ 11 }
                    weight={ 500 }
                    upperCase={ true }
                    isBlock={ true }
                    color="#000"
                >{ __("Next step button:", "seoaic") }</Text>
            </TopSpace>

            <Flex
                gap={2}
                align="center"
                justify="space-between"
                className="seoaic-multistep-form-option"
            >
                <FlexBlock>
                    <TextControl
                        label={ __('Text:', 'seoaic') }
                        value={ currentStep.buttons[0]?.text ?? '' }
                        onChange={ newValue => updateButton(0, 'text', newValue) }
                        type="text"
                        placeholder={ __("Button text", "seoaic") }
                    />
                </FlexBlock>
                <FlexBlock>
                    <SelectControl
                        label={ __('Step:', 'seoaic') }
                        value={ currentStep.buttons[0]?.step ?? '' }
                        onChange={ newValue => updateButton(0, 'step', newValue) }
                        options={ CTAStepsOptions }
                    />
                </FlexBlock>
            </Flex>
        </>
    );
};

export default MultiChoice;