import { useState, useEffect } from 'react';
import { __ } from '@wordpress/i18n';
import {
    TextareaControl,
    SelectControl,
} from '@wordpress/components';
import TopSpace from '../top-space';

const Message = ({
    steps,
    currentStep,
    CTAStepsOptions,
    setFormItems,
    updateFormItem,
    updateAutostep
}) => {
    const messageTmpt = {
        type: 'message',
        text: ''
    };

    useEffect(() => {
        if (0 == currentStep.formItems.length) {
            setFormItems([messageTmpt]);
        }
    }, [steps]);

    return (
        <>
            <TopSpace>
                <TextareaControl
                    label={ __("Message text:", "seoaic") }
                    rows={3}
                    value={ currentStep.formItems[0]?.text }
                    onChange={ newValue => updateFormItem(0, 'text', newValue) }
                />
                <SelectControl
                    label={ __('Next step:', 'seoaic') }
                    value={ currentStep.autostep ?? '' }
                    onChange={ newValue => updateAutostep(newValue) }
                    options={ CTAStepsOptions }
                />
            </TopSpace>
        </>
    );
};

export default Message;