import { __ } from '@wordpress/i18n';
import { useState, useEffect } from 'react';
import {
    Button,
    TextControl,
    SelectControl,
    Flex,
    FlexBlock,
    FlexItem,
    __experimentalText as Text,
    Dashicon
} from '@wordpress/components';
import ContactFieldRepeater from './contact-field-repeater';
import TopSpace from '../top-space';

const ContactFields = ({
    steps,
    currentStep,
    CTAStepsOptions,
    setFormItems,
    addFormItem,
    updateFormItem,
    removeFormItem,
    addButton,
    updateButton,
    moveItemUp,
    moveItemDown,
}) => {
    const inputTmpt = {
        type: 'text',
        text: '',
        className: '',
    };

    const selectTmpt = {
        type: 'select',
        text: '',
        options: ['']
    };

    const buttonTmpt = {
        text: '',
        step: null
    };

    const formFieldsTmpt = [{
        type: 'text',
        text: __('Name', 'seoaic'),
        className: 'seoaic-input-name-icon',
    }, {
        type: 'email',
        text: __('Email', 'seoaic'),
        className: 'seoaic-input-email-icon',
    }, {
        type: 'tel',
        text: __('Phone Number', 'seoaic'),
        className: 'seoaic-input-tel-icon',
    }, {
        type: 'select',
        text: __('Preferred Contact Method', 'seoaic'),
        options: [__('Phone', 'seoaic'), __('Email', 'seoaic')]
    }];


    useEffect(() => {
        if (0 == currentStep.formItems.length) {
            setFormItems(formFieldsTmpt);
        }

        if (0 == currentStep.buttons.length) {
            addButton(buttonTmpt);
        }
    }, [steps]);

    return (
    <>
        <ContactFieldRepeater
            currentStep={ currentStep }
            updateFormItem={ updateFormItem }
            removeFormItem={ removeFormItem }
            moveItemUp={ moveItemUp }
            moveItemDown={ moveItemDown }
        />
        <Flex
            gap={2}
            align="center"
            justify="start"
        >
            <FlexItem>
                <Button
                    className="seoaic-multistep-add-choice-btn"
                    title={ __("Add input field", "seoaic") }
                    variant="tertiary"
                    onClick={ () => addFormItem(inputTmpt) }
                ><Dashicon icon="insert" />&nbsp;{ __("Input field", "seoaic") }</Button>
            </FlexItem>
            <FlexItem>
                <Button
                    className="seoaic-multistep-add-choice-btn"
                    title={ __("Add drop-down select", "seoaic") }
                    variant="tertiary"
                    onClick={ () => addFormItem(selectTmpt) }
                ><Dashicon icon="insert" />&nbsp;{ __("Drop-down list", "seoaic") }</Button>
            </FlexItem>
        </Flex>
        <TopSpace>
            <Text
                variant="caption"
                size={ 11 }
                weight={ 500 }
                upperCase={ true }
                isBlock={ true }
                color="#000"
            >{ __("Next step button:", "seoaic") }</Text>
        </TopSpace>
        <Flex
            gap={2}
            align="center"
            justify="start"
            className="seoaic-multistep-form-option"
        >
            <FlexBlock>
                <TextControl
                    label={ __('Text:', 'seoaic') }
                    value={ currentStep.buttons[0]?.text ?? '' }
                    onChange={ newValue => updateButton(0, 'text', newValue) }
                    type="text"
                    placeholder={ __("Button text", "seoaic") }
                />
            </FlexBlock>
            <FlexBlock>
                <SelectControl
                    label={ __('Step:', 'seoaic') }
                    value={ currentStep.buttons[0]?.step ?? '' }
                    onChange={ newValue => updateButton(0, 'step', newValue) }
                    options={ CTAStepsOptions }
                />
            </FlexBlock>
        </Flex>
    </>
    );
};

export default ContactFields;