import { __ } from '@wordpress/i18n';
import {
    Button,
    __experimentalInputControl as InputControl,
    Flex,
    FlexBlock,
    FlexItem,
    __experimentalText as Text,
    Dashicon
} from '@wordpress/components';
import TopSpace from '../top-space';
import MoveButtons from '../move-buttons';

const ContactFieldRepeater = ({
    currentStep,
    updateFormItem,
    removeFormItem,
    moveItemUp,
    moveItemDown,
}) => {
    const inputTypes = ['text', 'email', 'tel'];

    const addDropDownOption = (i) => {
        const options = currentStep.formItems[i].options;

        options.push('');

        updateFormItem(i, 'options', options);
    };

    const editDropDownOption = (formItemIndex, optionIndex, newValue) => {
        const options = currentStep.formItems[formItemIndex].options;

        options[optionIndex] = newValue;

        updateFormItem(formItemIndex, 'options', options);
    };

    const removeDropDownOption = (formItemIndex, optionIndex) => {
        const options = currentStep.formItems[formItemIndex].options.filter((value, i) => i != optionIndex);

        updateFormItem(formItemIndex, 'options', options);
    };

    return (
        <>
        <TopSpace>
            <Text
                variant="caption"
                size={ 11 }
                weight={ 500 }
                upperCase={ true }
                isBlock={ true }
                color="#000"
            >{ __("Fields:", "seoaic") }</Text>
        </TopSpace>
        { currentStep.formItems.map((item, i) => {
            return (
                <Flex className="seoaic-multistep-form-option">
                    <FlexItem>
                        <MoveButtons
                            index={ i }
                            itemsCount={ currentStep.formItems.length }
                            moveUp={ () => moveItemUp('formItems', i) }
                            moveDown={ () => moveItemDown('formItems', i) }
                        />
                    </FlexItem>
                    <FlexBlock>
                        { inputTypes.includes(item.type)
                        ? (
                            <Flex>
                                {
                                    '' != item.className
                                    && <FlexItem>
                                        <div className={ item.className }></div>
                                    </FlexItem>
                                }
                                <FlexBlock>
                                    <InputControl
                                        label={ __("Label", "seoaic") }
                                        labelPosition="edge"
                                        value={ item.text }
                                        type={ item.type }
                                        onChange={ newValue => { updateFormItem(i, 'text', newValue); } }
                                    />
                                </FlexBlock>
                            </Flex>
                        )
                        : (
                            'select' == item.type
                            && 0 < item.options.length
                            ? (
                                <Flex className="seoaic-ms-fields-dd-field">
                                    <FlexBlock>
                                        <InputControl
                                            placeholder={ __("Drop-down Label", "seoaic") }
                                            value={ item.text }
                                            onChange={ newValue => { updateFormItem(i, 'text', newValue); } }
                                        />
                                    </FlexBlock>
                                    <FlexBlock>
                                        { item.options.map((text, optionIndex) => {
                                            return (
                                                <Flex>
                                                    <FlexBlock>
                                                        <InputControl
                                                        placeholder={ __("Option", "seoaic") }
                                                        value={ text }
                                                        onChange={ newValue => { editDropDownOption(i, optionIndex, newValue); } }
                                                        className="seoaic-ms-contact-form-option"
                                                    />
                                                    </FlexBlock>
                                                    <FlexItem>
                                                        <Button
                                                            className="seoaic-multistep-remove-choice-btn"
                                                            title={ __("Remove option", "seoaic") }
                                                            variant="tertiary"
                                                            onClick={ () => removeDropDownOption(i, optionIndex) }
                                                        ><Dashicon icon="minus" /></Button>
                                                    </FlexItem>
                                                </Flex>
                                            );
                                        }) }
                                        <Button
                                            className="seoaic-multistep-add-choice-btn"
                                            title={ __("Add drop-down option", "seoaic") }
                                            variant="tertiary"
                                            onClick={ () => addDropDownOption(i) }
                                        ><Dashicon icon="plus-alt2" />&nbsp;{ __("Option", "seoaic") }</Button>
                                    </FlexBlock>
                                </Flex>
                            )
                            : ''
                        ) }
                    </FlexBlock>
                    <FlexItem>
                        <Button
                            className="seoaic-multistep-remove-choice-btn"
                            title={ __("Remove field", "seoaic") }
                            variant="tertiary"
                            onClick={ () => removeFormItem(i) }
                        ><Dashicon icon="remove" /></Button>
                    </FlexItem>
                </Flex>
            );
        }) }
        </>
    );
};

export default ContactFieldRepeater;