/**
 * Registers a new block provided a unique name and an object defining its behavior.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-registration/
 */

/**
 * Lets webpack process CSS, SASS or SCSS files referenced in JavaScript files.
 * All files containing `style` keyword are bundled together. The code used
 * gets applied both to the front of your site and to the editor.
 *
 * @see https://www.npmjs.com/package/@wordpress/scripts#using-css
 */

import './style.scss';

/**
 * Internal dependencies
*/
import Edit from './edit';
import Save from './save';
import metadata from './block.json';
import { __ } from '@wordpress/i18n';
import { registerBlockType } from '@wordpress/blocks';


/**
 * Every block starts by registering a new block type definition.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-registration/
 */
registerBlockType( metadata.name, {
    keywords: [__("Interactive", "seoaic"), __("Article", "seoaic"), __("Interactive Article", "seoaic"), "SEOAI", "SEO"],
    attributes: {
        id: {
            type: "string"
        },
        post_id: {
            type: "number"
        },
        type: {
            type: "string"
        },
        question: {
            type: "string"
        },
        answers: {
            type: "array"
        },
        buttons: {
            type: "array"
        },
    },
    edit: Edit,
    save: Save,
} );
