import { __ } from '@wordpress/i18n';
import {
    Button,
    TextControl,
    SelectControl,
    Flex,
    FlexBlock,
    FlexItem,
    Dashicon,
    __experimentalText as Text
} from '@wordpress/components';
import { v4 as uuidv4 } from 'uuid';
import TopSpace from '../../../multistep-lead-form/components/top-space';
import MoveButtons from '../../../multistep-lead-form/components/move-buttons';

const SingleChoice = ({
    attributes,
    setAttributes,
    interactiveBlocksOptions,
    addButton,
    updateButton,
    removeButton,
    moveItemUp,
    moveItemDown,
    answersStats,
}) => {
    const singleChoiceButtonTmpt = {
        id: '',
        text: '',
        step: null,
    };

    const makeNewSingleChoiceButton = () => Object.assign(singleChoiceButtonTmpt, {id: uuidv4()});

    const addSingleChoice = () => {
        addButton(makeNewSingleChoiceButton());
    };

    if (
        !attributes.buttons
        || 0 == attributes.buttons.length
    ) {
        setAttributes({
            buttons: [makeNewSingleChoiceButton()]
        });

    } else {
        attributes.buttons.map((button, i) => {
            if (!button.id) {
                updateButton(i, 'id', uuidv4());
            }
        });
    }


    return (
        <>
            <TopSpace>
                <Text
                    variant="caption"
                    size={ 11 }
                    weight={ 500 }
                    upperCase={ true }
                    isBlock={ true }
                    color="#000"
                >{ __("Choices (buttons):", "seoaic") }</Text>
            </TopSpace>
            { attributes.buttons
            && attributes.buttons.map((button, i) =>
                <div
                    className="seoaic-multistep-form-option"
                >
                    <Flex
                        gap={2}
                        align="center"
                        justify="space-between"
                        className="seoaic-ms-single-option-row"
                    >
                        <FlexItem
                            className="seoaic-ia-answer-stats"
                            title={ __("Clicks count", "seoaic") }
                            data-id={ button.id }
                        >
                            {
                                answersStats[button.id] ? answersStats[button.id] : 0
                            }
                        </FlexItem>
                        <FlexItem>
                            <MoveButtons
                                index={ i }
                                itemsCount={ attributes.buttons.length }
                                moveUp={ () => moveItemUp('buttons', i) }
                                moveDown={ () => moveItemDown('buttons', i) }
                            />
                        </FlexItem>
                        <FlexBlock>
                            <TextControl
                                label={ __('Text:', 'seoaic') }
                                value={ button.text }
                                onChange={ newValue => updateButton(i, 'text', newValue) }
                                type="text"
                                placeholder={ __("Button text", "seoaic") }
                                __nextHasNoMarginBottom
                            />
                        </FlexBlock>
                        <FlexBlock>
                            <SelectControl
                                label={ __('Step:', 'seoaic') }
                                value={ button.step }
                                onChange={ newValue => updateButton(i, 'step', newValue) }
                                options={ interactiveBlocksOptions }
                                __nextHasNoMarginBottom
                            />
                        </FlexBlock>
                        <FlexItem>
                            <Button
                                className="seoaic-multistep-remove-choice-btn"
                                title={ __("Remove choice", "seoaic") }
                                variant="tertiary"
                                onClick={ () => removeButton(i) }
                            ><Dashicon icon="remove" /></Button>
                        </FlexItem>
                    </Flex>
                </div>
            ) }
            <Button
                className="seoaic-multistep-add-choice-btn"
                title={ __("Add new choice", "seoaic") }
                variant="tertiary"
                onClick={ addSingleChoice }
            ><Dashicon icon="insert" />&nbsp;{ __("New choice", "seoaic") }</Button>
        </>
    );
};

export default SingleChoice;