import { __ } from '@wordpress/i18n';
import {
    TextareaControl,
    TextControl,
    SelectControl,
    Flex,
    FlexBlock,
    __experimentalText as Text
} from '@wordpress/components';
import TopSpace from '../../../multistep-lead-form/components/top-space';

const OpenTextField = ({
    attributes,
    setAttributes,
    interactiveBlocksOptions,
    updateAnswer,
    updateButton,
})=> {
    const buttonTmpt = {
        text: '',
        step: null
    };

    const textareaTmpt = {
        type: 'textarea',
        placeholder: __("Your answer", "")
    };

    if (0 == attributes.answers.length) {
        setAttributes({
            answers: [textareaTmpt]
        });
    }

    if (
        !attributes.buttons
        || 0 == attributes.buttons.length
    ) {
        setAttributes({
            buttons: [buttonTmpt]
        });
    }


    return (
        <>
            <TopSpace>
                <TextareaControl
                    label={ __("User's input field (preview):", "seoaic") }
                    help={ __("A preview of the textarea for user's input. You can save placeholder inside.","seoaic") }
                    rows={3}
                    value={ attributes.answers[0]?.placeholder }
                    onChange={ newValue => updateAnswer(0, 'placeholder', newValue) }
                />
            </TopSpace>
            <TopSpace>
                <Text
                    variant="caption"
                    size={ 11 }
                    weight={ 500 }
                    upperCase={ true }
                    isBlock={ true }
                    color="#000"
                >{ __("Next step button:", "seoaic") }</Text>
            </TopSpace>

            { attributes.buttons
            && <Flex
                gap={2}
                align="center"
                justify="space-between"
                className="seoaic-multistep-form-option"
            >
                <FlexBlock>
                    <TextControl
                        label={ __('Text:', 'seoaic') }
                        value={ attributes.buttons[0]?.text ?? '' }
                        onChange={ newValue => updateButton(0, 'text', newValue) }
                        type="text"
                        placeholder={ __("Button text", "seoaic") }
                    />
                </FlexBlock>
                <FlexBlock>
                    <SelectControl
                        label={ __('Step:', 'seoaic') }
                        value={ attributes.buttons[0]?.step ?? '' }
                        onChange={ newValue => updateButton(0, 'step', newValue) }
                        options={ interactiveBlocksOptions }
                    />
                </FlexBlock>
            </Flex> }
        </>
    );
};

export default OpenTextField;