import { __ } from '@wordpress/i18n';
import {
    Button,
    TextControl,
    SelectControl,
    Flex,
    FlexBlock,
    FlexItem,
    __experimentalText as Text,
    Dashicon
} from '@wordpress/components';
import { v4 as uuidv4 } from 'uuid';
import TopSpace from '../../../multistep-lead-form/components/top-space';
import MoveButtons from '../../../multistep-lead-form/components/move-buttons';

const MultiChoice = ({
    attributes,
    setAttributes,
    interactiveBlocksOptions,
    addAnswer,
    updateAnswer,
    removeAnswer,
    updateButton,
    moveItemUp,
    moveItemDown,
    answersStats,
}) => {
    const checkboxTmpt = {
        id: '',
        type: 'checkbox',
        text: '',
    };
    const buttonTmpt = {
        text: '',
        step: null
    };

    const makeNewCheckbox = () => Object.assign(checkboxTmpt, {id: uuidv4()});

    const addMultiChoice = () => {
        addAnswer(makeNewCheckbox());
    };

    if (
        !attributes.answers
        || 0 == attributes.answers.length
    ) {
        setAttributes({
            answers: [makeNewCheckbox()]
        });

    } else {
        attributes.answers.map((answer, i) => {
            if (!answer.id) {
                updateAnswer(i, 'id', uuidv4());
            }
        });
    }

    if (
        !attributes.buttons
        || 0 == attributes.buttons.length
    ) {
        setAttributes({
            buttons: [buttonTmpt]
        });
    }


    return (
        <>
            <TopSpace>
                <Text
                    variant="caption"
                    size={ 11 }
                    weight={ 500 }
                    upperCase={ true }
                    isBlock={ true }
                    color="#000"
                >{ __("Choices (checkboxes):", "seoaic") }</Text>
            </TopSpace>
            { attributes.answers.map((answer, i) =>
                <div
                    className="seoaic-multistep-form-option"
                >
                    <Flex
                        gap={2}
                        align="center"
                        justify="space-between"
                        className="seoaic-ms-multi-option-row"
                    >
                        <FlexItem
                            className="seoaic-ia-answer-stats"
                            title={ __("Clicks count", "seoaic") }
                            data-id={ answer.id }
                        >
                            {
                                answersStats[answer.id] ? answersStats[answer.id] : 0
                            }
                        </FlexItem>
                        <FlexItem>
                            <MoveButtons
                                index={ i }
                                itemsCount={ attributes.answers.length }
                                moveUp={ () => moveItemUp('answers', i) }
                                moveDown={ () => moveItemDown('answers', i) }
                            />
                        </FlexItem>
                        <FlexBlock>
                            <TextControl
                                value={ answer.text }
                                onChange={ newValue => updateAnswer(i, 'text', newValue) }
                                type="text"
                                className="seoaic-ms-multi-option-input"
                                placeholder={ __("Option text", "seoaic") }
                                __nextHasNoMarginBottom
                            />
                        </FlexBlock>
                        <FlexItem>
                            <Button
                                className="seoaic-multistep-remove-choice-btn"
                                title={ __("Remove choice", "seoaic") }
                                variant="tertiary"
                                onClick={ () => removeAnswer(i) }
                            ><Dashicon icon="remove" /></Button>
                        </FlexItem>
                    </Flex>
                </div>
            ) }

            <Button
                className="seoaic-multistep-add-choice-btn"
                title={ __("Add new choice", "seoaic") }
                variant="tertiary"
                onClick={ addMultiChoice }
            ><Dashicon icon="insert" />&nbsp;{ __("New choice", "seoaic") }</Button>

            <TopSpace>
                <Text
                    variant="caption"
                    size={ 11 }
                    weight={ 500 }
                    upperCase={ true }
                    isBlock={ true }
                    color="#000"
                >{ __("Next step button:", "seoaic") }</Text>
            </TopSpace>

            { attributes.buttons
            && <Flex
                gap={2}
                align="center"
                justify="space-between"
                className="seoaic-multistep-form-option"
            >
                <FlexBlock>
                    <TextControl
                        label={ __('Text:', 'seoaic') }
                        value={ attributes.buttons[0]?.text ?? '' }
                        onChange={ newValue => updateButton(0, 'text', newValue) }
                        type="text"
                        placeholder={ __("Button text", "seoaic") }
                    />
                </FlexBlock>
                <FlexBlock>
                    <SelectControl
                        label={ __('Step:', 'seoaic') }
                        value={ attributes.buttons[0]?.step ?? '' }
                        onChange={ newValue => updateButton(0, 'step', newValue) }
                        options={ interactiveBlocksOptions }
                    />
                </FlexBlock>
            </Flex>
            }
        </>
    );
};

export default MultiChoice;